/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2011  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "settingsdialog.h"
#include "ui_settings.h"
#include <QUrl>
#include <QDesktopServices>
#include <QDebug>

#define URL_HELP                        "http://babyphone.garage.maemo.org/index.html#sec_settings"


/*!
  The constructor sets up the user interface and sets its values.
*/
SettingsDialog::SettingsDialog(Settings *settings, QWidget *parent) :
    QDialog(parent), ui(new Ui::Dialog), itsSettings(settings)
{
    ui->setupUi(this);
    setWindowModality(Qt::WindowModal);
    itsHorizontalLayout = true;

    // setup values of GUI elements
    ui->spinBox_volume->setValue(itsSettings->itsAudioAmplify);
    ui->spinBox_timeWeight->setValue(itsSettings->itsAudioTimer);
    ui->spinBox_callSetupTimer->setValue(itsSettings->itsCallSetupTimer);
    ui->spinBox_activationDelay->setValue(itsSettings->itsActivationDelay);
    ui->spinBox_recallTimer->setValue(itsSettings->itsRecallTimer);
    ui->checkBox_switchProfile->setChecked(itsSettings->itsSwitchProfile);
    ui->checkBox_sendSMS->setChecked(itsSettings->itsSendSMS);
    ui->checkBox_showStatistic->setChecked(itsSettings->itsShowStatistics);
    ui->checkBox_rejectIncomingCalls->setChecked(itsSettings->itsHandleIncomingCalls);
    ui->checkBox_disableAutorotate->setChecked(itsSettings->itsDisableAutoRotate);

    // connect help
    connect(ui->buttonBox, SIGNAL(helpRequested()), this, SLOT(ShowHelp()));
}


/*!
  resizeEvent takes care for layout switches (horizonatal/vertical).
*/
void SettingsDialog::resizeEvent(QResizeEvent *)
{
    if ( (LAYOUT_CHANGE_RATIO*height() > width()) && itsHorizontalLayout) {
        // switch to vertical layout
        qDebug() << "switching to vertical setting layout";
        itsHorizontalLayout = false;

        // adjust main layout
        ui->mainLayout->setDirection(QBoxLayout::TopToBottom);

        // adjust button box layout
        ui->buttonBox->setOrientation(Qt::Horizontal);
    }
    else if ((LAYOUT_CHANGE_RATIO*height() < width()) && !itsHorizontalLayout) {
        // switch to vertical layout
        qDebug() << "switching to horizontal setting layout";
        itsHorizontalLayout = true;

        // adjust main layout
        ui->mainLayout->setDirection(QBoxLayout::LeftToRight);

        // adjust button box layout
        ui->buttonBox->setOrientation(Qt::Vertical);
    }
}


/*!
  SaveData stores its values to the settings class
*/
void SettingsDialog::SaveData()
{
    // store new settings
    itsSettings->itsAudioAmplify = ui->spinBox_volume->value();
    itsSettings->itsAudioTimer = ui->spinBox_timeWeight->value();
    itsSettings->itsCallSetupTimer = ui->spinBox_callSetupTimer->value();
    itsSettings->itsActivationDelay = ui->spinBox_activationDelay->value();
    itsSettings->itsRecallTimer = ui->spinBox_recallTimer->value();
    itsSettings->itsSwitchProfile = ui->checkBox_switchProfile->isChecked();
    itsSettings->itsSendSMS = ui->checkBox_sendSMS->isChecked();
    itsSettings->itsShowStatistics = ui->checkBox_showStatistic->isChecked();
    itsSettings->itsHandleIncomingCalls = ui->checkBox_rejectIncomingCalls->isChecked();
    itsSettings->itsDisableAutoRotate = ui->checkBox_disableAutorotate->isChecked();
}


/*!
  ShowHelp launches the online help.
*/
void SettingsDialog::ShowHelp()
{
    QDesktopServices::openUrl(QUrl(URL_HELP));
}
