/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2011  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>

#include "audiolevelgraphicsscene.h"
#include "settings.h"
#include "profileswitcher.h"
#include "babyphone.h"


namespace Ui {
    class MainWindow;
}


/*!
  MainWindow is the main application class that handles the UI interaction and
  holds references to the functionality classes.
  Initially it sets up the user interface and starts the audio capturing. It
  instantiates the Settings as well as the UserNotifier.
*/
class MainWindow : public QMainWindow
{
    Q_OBJECT

// types
private:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };


public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void resizeEvent(QResizeEvent * event);

private:
    void setupGui();
    void setOrientation(ScreenOrientation orientation);
    void showFirstRunInfo() const;
    void activateMonitor();
    void deactivateMonitor();

private slots:
    void newAudioData(int counter, int value);
    void newCallStatus(bool finish, bool selfInitiated);
    void showNotificationError() const;
    void activationTimerExpired();
    void bringWindowToFront();
    void displayDimmed(const QDBusMessage&);

    void on_pushButton_clicked();
    void on_pushButton_contacts_clicked();
    void on_pushButton_enterNumber_clicked();
    void on_actionAbout_triggered();
    void on_actionSettings_triggered();


private:
    //! autogenerated user interface
    Ui::MainWindow *ui;

    //! indication whether the screen has horizontal or vertical design
    bool itsHorizontalLayout;

    //! the graphics item holding the volume audio chart
    AudioLevelGraphicsScene *itsAudioLevelGraphics;

    //! the graphics item holding the time related audio threshold counter
    AudioLevelGraphicsScene *itsAudioCounterGraphics;

    //! master reference to global application settings
    Settings *itsSettings;

    //! the profile switcher to disable the ringtones
    ProfileSwitcher *itsProfileSwitcher;

    //! application status: if true the application is actually shown on the screen
    bool itsIsScreenOff;

    //! timer for delayed activation
    QTimer itsActivationDelayTimer;

    //! the main state machine on audio monitoring and call notifications
    Babyphone *itsBabyphone;
};


#endif // MAINWINDOW_H
