/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef AUDIOLEVELGRAPHICSSCENE_H
#define AUDIOLEVELGRAPHICSSCENE_H

#include <QGraphicsScene>
#include "settings.h"


/*!
  AudioLevelGraphicsScene provides specialized graphic items to display the audio
  properties over time.
  It gets called with each new audio sample and creates the graph. The graph 
  already provides a line for the threshold value, which is determined by 
  reading the application settings. Also AudioLevelGraphicsScene configures the
  properties of the displaying QGraphicsView.
*/
class AudioLevelGraphicsScene : public QGraphicsScene
{
public:
    AudioLevelGraphicsScene(QGraphicsView *graphicsView, Settings *settings, QObject *parent);
    void AddValue(float value);
    void Clear();


private:
    float GetYPos(float value);


private:
    //! reference to global application settings
    Settings *itsSettings;
	
    //! actual drawing position on x-axes
    int itsCurrentPosition;
	
    //! total width of graphics in pixel
    int itsWidth;

    //! transform factor to scale the input values into y-pixels
    float itsScale;
};


#endif // AUDIOLEVELGRAPHICSSCENE_H
