/*
 * azimuth.h - Header for Azimith
 * Copyright (C) 2010 Guillaume Desmottes
 * @author Guillaume Desmottes <gdesmott@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __AZIMUTH_H__
#define __AZIMUTH_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _Azimuth Azimuth;
typedef struct _AzimuthClass AzimuthClass;

struct _AzimuthClass {
    GObjectClass parent_class;
};

struct _Azimuth {
    GObject parent;
};

GType azimuth_get_type (void);

/* TYPE MACROS */
#define AZIMUTH_TYPE \
  (azimuth_get_type())
#define AZIMUTH(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), AZIMUTH_TYPE, Azimuth))
#define AZIMUTH_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), AZIMUTH_TYPE, AzimuthClass))
#define IS_AZIMUTH(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), AZIMUTH_TYPE))
#define IS_AZIMUTH_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), AZIMUTH_TYPE))
#define AZIMUTH_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), AZIMUTH_TYPE, AzimuthClass))

Azimuth * azimuth_new (void);

void azimuth_run (Azimuth *self);

G_END_DECLS

#endif /* #ifndef __AZIMUTH_H__*/
