/*
 * position-watcher.h - Header for PositionWatcher
 * Copyright (C) 2010 Guillaume Desmottes
 * @author Guillaume Desmottes <gdesmott@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __POSITION_WATCHER_H__
#define __POSITION_WATCHER_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _PositionWatcher PositionWatcher;
typedef struct _PositionWatcherClass PositionWatcherClass;

struct _PositionWatcherClass {
    GObjectClass parent_class;
};

struct _PositionWatcher {
    GObject parent;
};

GType position_watcher_get_type(void);

/* TYPE MACROS */
#define POSITION_WATCHER_TYPE \
  (position_watcher_get_type())
#define POSITION_WATCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), POSITION_WATCHER_TYPE, PositionWatcher))
#define POSITION_WATCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), POSITION_WATCHER_TYPE, PositionWatcherClass))
#define POSITION_IS_WATCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), POSITION_WATCHER_TYPE))
#define POSITION_IS_WATCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), POSITION_WATCHER_TYPE))
#define POSITION_WATCHER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), POSITION_WATCHER_TYPE, PositionWatcherClass))

PositionWatcher * position_watcher_new (void);

void position_watcher_start (PositionWatcher *watcher);

G_END_DECLS

#endif /* #ifndef __POSITION_WATCHER_H__*/
