#!/bin/sh

pixmaps="/usr/share/pixmaps/*.png"
extras="/usr/share/icons/awoken-icon-theme/extras/*"
original="/home/user/.awoken-extras/orig/"

if [ "$(ls -A $original)" ]; then
	for bilder in $original
        do 
            bild=`basename ${bilder}`
            for ikon in ${pixmaps}
            do
                iko=`basename ${ikon}`

                    if [ "${bild}" != "${iko}" ]; then                    	
                    	cp /usr/share/pixmaps/${iko} $original
                    fi
                    
            done
        done
else
	mkdir $original
	cp $pixmaps".png" $original
fi	

case "$1" in
    '-'[Cc] | '--change')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	cp ${img} /usr/share/pixmaps/
                    	echo ""
                    fi
                    
            done
        done
    exit
    ;;
    '-'[Bb] | '--backup')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	rm ${pics}.orig
                    	cp ${pics} ${pics}.orig
                    	echo ""
                    fi
                    
            done
        done
    exit
    ;;
    '-'[Rr] | '--reset')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	mv ${pics}.orig ${pics}
                    	echo ""
                    fi
                    
            done
        done
    exit
    ;;
esac
