#include "playlist.h"
#include "ui_playlist.h"
#include <QMap>


Playlist::Playlist(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Playlist)
{
    ui->setupUi(this);
    playlistlist = new Playlists();
    this->updateList();
    ui->treeWidget->setColumnCount(1);




}

Playlist::~Playlist()
{
    delete ui;
}

void Playlist::on_treeWidget_itemClicked(QTreeWidgetItem *item, int column)
{

    if (column == 0)
    {
        if (item->childCount() == 0)
            this->articleSelected(item, column);

        else
            this->playlistSelected(item->takeChildren(), column);

        this->hide();
    }
    if (column == 1)
    {
        if (item->childCount() == 0)
            playlistlist->removePlaylistItem(item->data(1, 1).toString(), column, item->parent());

        else
            playlistlist->removePlaylist(item->text(column));

        this->updateList();
    }

}

QStringList Playlist::getPlaylists()
{
    return playlistlist->getPlaylistTitles();
}

void Playlist::addToPlaylist(QString playlist, QString article)
{
    playlistlist->addNewItemToPlaylist(playlist, article);
    this->updateList();
}

void Playlist::updateList()
{
    this->ui->treeWidget->clear();
    QList<QTreeWidgetItem *> items;
    QList<QTreeWidgetItem *> removes;
    foreach(QString title, this->playlistlist->getPlaylistTitles())
    {
        QTreeWidgetItem *itemRemove = new QTreeWidgetItem(QStringList("Remove"));
        itemRemove->setData(1, 1, QVariant(title));
        QTreeWidgetItem *item = new QTreeWidgetItem(QStringList(title));
        QList<QTreeWidgetItem*> children;
        foreach (QString article, this->playlistlist->getPlaylistContent(title))
            children.append(new QTreeWidgetItem(QStringList(article)));
        item->addChildren(children);
        items.append(item);
        removes.append(itemRemove);
       // item->set
        //this->ui->treeWidget->addTopLevelItem(item);
    }
    this->ui->treeWidget->insertTopLevelItems(0, items);
    this->ui->treeWidget->insertTopLevelItems(1, removes);
}

