#ifndef LINKLIST_H
#define LINKLIST_H

#include <QWidget>
#include <QListWidgetItem>
#include <QSplashScreen>

namespace Ui {
    class LinkList;
}

class LinkList : public QSplashScreen
{
    Q_OBJECT

public:
    explicit LinkList(QStringList links, QWidget *parent = 0);
    ~LinkList();

private slots:
    void on_linkListWidget_itemClicked(QListWidgetItem *item);

    void on_closeButton_clicked();

signals:
    void linkClicked(QListWidgetItem *item);

private:
    Ui::LinkList *ui;
};

#endif // LINKLIST_H
