#ifndef CONTROL_H
#define CONTROL_H

#include <QObject>
#include <QMainWindow>
#include <QStandardItemModel>
#include "booklistwidget.h"
#include "readwidget.h"

class QModelIndex;
class QStandardItem;

class Control : public QObject
{
    Q_OBJECT

public:

    Control( QObject* aParent = 0);

    ~Control();

public slots:

    void addBooks();

    void createNewBook();

    void readBook(int aIndex);

    void removeBook(int aIndex);

private slots:

    void loadBookList();

    void storeBookList();

    bool isBookAdded( const QString& aBookName );

private:

    QStandardItemModel mBookListModel;
    BookListWidget mBookListWidget;
    ReadWidget mReadWidget;
};

#endif // CONTROL_H
