#include "booklistwidget.h"

#include <QVBoxLayout>
#include <QPushButton>
#include <QListView>

#include "listitemdelegate.h"

BookListWidget::BookListWidget(QStandardItemModel* aModel,QWidget* aParent )
        :QWidget( aParent ),mBookListModel(aModel)
{
    setupUi();    
}

BookListWidget::~BookListWidget()
{
}

void BookListWidget::setModel( QStandardItemModel* aModel )
{
    mBookListModel = aModel;
    mBookList->setModel(mBookListModel);
}

void BookListWidget::setupUi()
{
    QPushButton* addButton = new QPushButton("Add Audio",this);
    connect(addButton,SIGNAL(clicked()),this,SIGNAL(addNewBook()));

    QPushButton* createButton = new QPushButton("Add Folder",this);
    connect(createButton,SIGNAL(clicked()),this,SIGNAL(createNewBook()));

    mBookList = new QListView(this);
    mBookList->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);    
    ListItemDelegate* itemDelegate = new ListItemDelegate(mBookList);
    mBookList->setItemDelegate( itemDelegate );
    mBookList->setModel(mBookListModel);

    connect( itemDelegate,SIGNAL(readBookPressed(int)),this,SIGNAL(readBook(int)));
    connect( itemDelegate,SIGNAL(removeBookPressed(int)),this,SIGNAL(removeBook(int)));

    QHBoxLayout* buttonLayout = new QHBoxLayout;
    buttonLayout->addWidget(addButton);
    buttonLayout->addWidget(createButton);    

    QVBoxLayout* mainLayout = new QVBoxLayout(this);
    mainLayout->addLayout(buttonLayout);
    mainLayout->addWidget(mBookList);
}
