uniform highp mat4 ProjModelView;
uniform highp mat4 ShadowTexProj;
uniform mediump mat3 InverseTrans;
uniform mediump float scale;

attribute mediump vec4 vertex;
attribute mediump vec3 norm;
attribute mediump vec2 tex;

varying mediump vec3 normal;
varying highp vec2 texCoord;
varying highp vec4 shadowCoord;

void main() {
    gl_Position = ProjModelView*vec4(vertex.xyz*scale,vertex.w);
    shadowCoord = ShadowTexProj*vertex;
    
    normal = normalize(InverseTrans*norm);
    texCoord = tex;
}
