/* 
 * File:   view.h
 * Author: pavel
 *
 * Created on 17. Januar 2009, 01:39
 */

#pragma once

#include "Scene.h"

#ifdef NO_ES
	#include <GL/glew.h>
#endif

#include <QGLWidget>
#include <QTime>

/**
 * View for Managing Input & Output
 */
class View : public QGLWidget {
public:
    View(Scene& s, QWidget* p);
    void start();
    Scene& s;
protected:
    void initializeGL();
    void paintGL();
    void resizeGL(int width, int height);
    void keyPressEvent(QKeyEvent* event);
    bool event(QEvent *event);
    void mousePressEvent(QMouseEvent* event);
    void mouseMoveEvent(QMouseEvent* event);
	QTime time;
	int frameCnt;
};


