/*
 * VideoQuad.cpp
 *
 *  Created on: 22.10.2009
 *      Author: pavel
 */

#ifdef NO_ES
	#include <GL/glew.h>
	#include <GL/gl.h>
#else
	#include <GLES2/gl2.h>
#endif

#include "VideoQuad.h"

VideoQuad::VideoQuad(int _width, int _height) :
vid(_width, _height),
width(_width),
height(_height)
{}

void VideoQuad::setup() {
	const int nextPotW = 512;
	const int nextPotH = 256;

	const float w = float(width)/nextPotW;
	const float h = float(height)/nextPotH;

	const float quad[] = {-1,-1, 0,  // Pos
						 0, 0, 1,  // Normal
						 0, h,     // UV
						-1, 1, 0,
						 0, 0, 1,
						 0, 0,
						 1,-1, 0,
						 0, 0, 1,
						 w, h,
						 1, 1, 0,
						 0, 0, 1,
						 w, 0};

    glGenBuffers(1, &vbo);
    glBindBuffer(GL_ARRAY_BUFFER, vbo);
    glBufferData(GL_ARRAY_BUFFER, 8*4*sizeof(float), quad, GL_STATIC_DRAW);
    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind

    glGenTextures(1, &texture);
    glBindTexture(GL_TEXTURE_2D, texture);
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, nextPotW, nextPotH, 0, GL_RGB, GL_UNSIGNED_BYTE, 0);

    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glBindTexture(GL_TEXTURE_2D, 0); // unbind

    vid.start();
}

void VideoQuad::render(QGLShaderProgram& sp, bool frozen) {
    glBindBuffer(GL_ARRAY_BUFFER, vbo);
    glBindTexture(GL_TEXTURE_2D, texture);
    // update Texture: SubImage does not reallocate memory
    if(!frozen)
        glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, width, height, GL_RGB, GL_UNSIGNED_BYTE, vid.data);

    sp.enableAttributeArray("vertex");
    sp.setAttributeArray("vertex", 0, 3, 8*sizeof(float));

    sp.enableAttributeArray("norm");
    sp.setAttributeArray("norm", (float*)(3*sizeof(float)), 3, 8*sizeof(float));

    sp.enableAttributeArray("tex");
    sp.setAttributeArray("tex", (float*)(6*sizeof(float)), 2, 8*sizeof(float));

    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind
    glBindTexture(GL_TEXTURE_2D, 0); // unbind
}

void VideoQuad::cleanup() {
	glDeleteTextures(1, &texture);
    glDeleteBuffers(1, &vbo);
}
