/*
 * Object.cpp
 *
 *  Created on: 23.10.2009
 *      Author: pavel
 */

#ifdef NO_ES
#include <GL/glew.h>
#include <GL/gl.h>
#else
#include <GLES2/gl2.h>
#endif
#include <QImage>
#include <iostream>

using namespace std;

#include "Object.h"

void Object::setup(ObjReader objFile) {
	QImage tex;
	QVector<float>& vboData = objFile.getVBO();
	slices = objFile.getSlices();

	glGenBuffers(1, &vbo);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	glBufferData(GL_ARRAY_BUFFER, vboData.size() * sizeof(float), vboData.data(), GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind

	// load textures
	for (int i = 0; i < slices.size(); i++) {
		tex.load(slices[i].path);
		tex = tex.scaledToWidth(tex.width());
		tex = QGLWidget::convertToGLFormat(tex);

		glGenTextures(1, &slices[i].texId);
		glBindTexture(GL_TEXTURE_2D, slices[i].texId);

		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, tex.width(), tex.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, tex.bits());
		glGenerateMipmap(GL_TEXTURE_2D);
	}

	// create depth texture used for Shadow Mapping
	// format is RGBA as SGX530 does not support depth_textures
	glGenTextures(1, &depthTex);
	glBindTexture(GL_TEXTURE_2D, depthTex);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, shadowMapSize, shadowMapSize, 0, GL_RGBA, GL_UNSIGNED_BYTE, 0);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);

	scale = 1;
}

void Object::render(QGLShaderProgram& sp) {
	glBindBuffer(GL_ARRAY_BUFFER, vbo);

	sp.enableAttributeArray("vertex");
	sp.setAttributeArray("vertex", 0, 3, 8 * sizeof(float));

	sp.enableAttributeArray("norm");
	sp.setAttributeArray("norm", (float*) (3 * sizeof(float)), 3, 8 * sizeof(float));

	sp.enableAttributeArray("tex");
	sp.setAttributeArray("tex", (float*) (6 * sizeof(float)), 2, 8 * sizeof(float));

	// bind depth our depth texture
	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D, depthTex);

	glActiveTexture(GL_TEXTURE0);

	for (int i = 0; i < slices.size(); i++) {
		glBindTexture(GL_TEXTURE_2D, slices[i].texId);
		glDrawArrays(GL_TRIANGLES, slices[i].start, slices[i].count);
	}

	glBindTexture(GL_TEXTURE_2D, 0);
	glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind
}

void Object::cleanup() {
	glDeleteBuffers(1, &vbo);
	glDeleteTextures(1, &depthTex);
	// should delete textures too
}
