/*
 * VideoQuad.cpp
 *
 *  Created on: 22.10.2009
 *      Author: pavel
 */

#ifdef NO_ES
#include <GL/glew.h>
#include <GL/gl.h>
#else
#include <GLES2/gl2.h>
#endif

#include "CanvasPlane.h"

QMatrix4x4 CanvasPlane::matFill;

CanvasPlane::CanvasPlane() :
    img(size, size, QImage::Format_ARGB32), newStroke(false) {

}

void CanvasPlane::setMatFill() {
    matFill.scale(1, -1 / 0.566, 1); // invert the aspect ratio of N900 and flip the y coordinate
}

void CanvasPlane::drawAt(float x, float y) {
    int ix = x * size;
    int iy = y * size;

    QPainter p(&img);
    p.setBrush(QColor(0, 0, 0));

    if (!newStroke)
        p.drawLine(lastX, lastY, ix, iy);
    else
        p.drawPoint(ix, iy);

    lastX = ix;
    lastY = iy;
    newStroke = false;
}

void CanvasPlane::setup(QColor& bg) {
    // world units
    // TODO convert to device size (depends on marker size)
    const float scale = 1;
    const float width = scale;
    const float height = scale * 0.566; // aspect ratio of N900

    const float quad[] = { -width, -height, 0, // Pos
            0, 1, 0, // Normal
            0, 1, // UV
            -width, height, 0,
            0, 1, 0,
            0, 0,
            width, -height, 0,
            0, 1, 0,
            1, 1,
            width, height, 0,
            0, 1, 0,
            1, 0 };

    glGenBuffers(1, &vbo);
    glBindBuffer(GL_ARRAY_BUFFER, vbo);
    glBufferData(GL_ARRAY_BUFFER, 8 * 4 * sizeof(float), quad, GL_STATIC_DRAW);
    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind

    this->img.fill(bg.rgba());
    QImage img = QGLWidget::convertToGLFormat(this->img);

    glGenTextures(1, &texture);
    glBindTexture(GL_TEXTURE_2D, texture);
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, img.width(), img.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, img.bits());

    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST); // TODO linear messes up object picking
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);

    glBindTexture(GL_TEXTURE_2D, 0); // unbind
}

void CanvasPlane::render(QGLShaderProgram& sp, QMatrix4x4& matPMV, bool editing) {
    glBindBuffer(GL_ARRAY_BUFFER, vbo);
    glBindTexture(GL_TEXTURE_2D, texture);

    if (editing) {
        // if user draws, we want to show the updates
        QImage img = QGLWidget::convertToGLFormat(this->img);
        glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, img.width(), img.height(), GL_RGBA, GL_UNSIGNED_BYTE, img.bits());
    }

    sp.enableAttributeArray("vertex");
    sp.setAttributeArray("vertex", 0, 3, 8 * sizeof(float));

    sp.enableAttributeArray("tex");
    sp.setAttributeArray("tex", (float*) (6 * sizeof(float)), 2, 8 * sizeof(float));

    // if we are being edited, display fullscreen else the saved location
    sp.setUniformValue("ProjModelView", editing ? matFill : matPMV*matMV);

    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

    glBindBuffer(GL_ARRAY_BUFFER, 0); // unbind
    glBindTexture(GL_TEXTURE_2D, 0); // unbind
}

void CanvasPlane::cleanup() {
    glDeleteTextures(1, &texture);
    glDeleteBuffers(1, &vbo);
}
