// checksum 0xfd0b version 0x20001
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
//#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>

#if defined(Q_OS_SYMBIAN) && defined(ORIENTATIONLOCK)
#include <eikenv.h>
#include <eikappui.h>
#include <aknenv.h>
#include <aknappui.h>
#endif // Q_OS_SYMBIAN && ORIENTATIONLOCK

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    //ui->setupUi(this);

    firstInstance = true;

    actAbout = new QAction(tr("About"), this);
    connect(actAbout, SIGNAL(triggered()),this, SLOT(showAbout()));
    menuBar()->addAction(actAbout);

    central = new QWidget(this);

    glay = new QGridLayout(central);

    buttonAddAll = new QPushButton();
    buttonAddAll->setText("Add arabic stations");
    buttonAddAll->setFont(QFont("Nokia Sans", 20, QFont::Normal));

    buttonDelAll = new QPushButton();
    buttonDelAll->setText("Delete arabic stations");
    buttonDelAll->setFont(QFont("Nokia Sans", 20, QFont::Normal));

    QSpacerItem *spacerItem = new QSpacerItem(0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);

    glay->addItem(spacerItem,0,0);
    glay->addWidget(buttonAddAll,1,0);
    glay->addWidget(buttonDelAll,2,0);
    central->setLayout(glay);
    setCentralWidget(central);

    //Background Image
    QPalette palette;
    QPixmap pixmap(":/main.png");
    palette.setBrush(backgroundRole(), pixmap);
    setPalette(palette);

    //Slots
    connect(buttonAddAll, SIGNAL(clicked()), this, SLOT(slotAddAllStations()));
    connect(buttonDelAll, SIGNAL(clicked()), this, SLOT(slotDelAllStations()));

}

void MainWindow::showAbout()
{
    QMaemo5InformationBox::information(this,
        tr("<br>arabiciradio v0.3.2<br>Is a little application that adds arabic stations to the media player.<br>Developed by Raed A using Qt, email: raedbenz@hotmail.com<br>"),
        QMaemo5InformationBox::NoTimeout);
}

void MainWindow::slotAddAllStations()
{
    mafwdb = new MafwDb( firstInstance );
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
    QCoreApplication::processEvents();

    //Connect to DB
    if(mafwdb->connectToMafwDb())
    {
        firstInstance = false;

        //Add stations
        if(mafwdb->addStationsToMafwDb())
        {
            QMaemo5InformationBox::information(this,
                tr("<br>Stations were added successfully!<br>Go to Media player to start listening.<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
        else
        {
            QMaemo5InformationBox::information(this,
                tr("<br><font color='red'>Operation failed.<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
    }
    else
    {
        QMaemo5InformationBox::information(this,
            tr("<br><font color='red'>Operation failed.<br>Make sure Media player is closed.<br>"),
            QMaemo5InformationBox::NoTimeout);
    }

    //Close DB
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
    mafwdb->closeMafwDb();
    delete mafwdb;
}

void MainWindow::slotDelAllStations()
{
    mafwdb = new MafwDb( firstInstance );
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
    QCoreApplication::processEvents();

    //Connect to DB
    if(mafwdb->connectToMafwDb())
    {
        firstInstance = false;

        //Delete Stations
        if(mafwdb->deleteStationsFromMafwDb())
        {
            QMaemo5InformationBox::information(this,
                tr("<br>Arabic stations were deleted successfully!<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
        else
        {
            QMaemo5InformationBox::information(this,
                tr("<br><font color='red'>Operation failed.<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
    }
    else
    {
        QMaemo5InformationBox::information(this,
            tr("<br><font color='red'>Operation failed.<br>Make sure Media player is closed.<br>"),
            QMaemo5InformationBox::NoTimeout);
    }

    //Close DB
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
    mafwdb->closeMafwDb();
    delete mafwdb;
}

MainWindow::~MainWindow()
{
    //delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#ifdef Q_OS_SYMBIAN
    if (orientation != ScreenOrientationAuto) {
#if defined(ORIENTATIONLOCK)
        const CAknAppUiBase::TAppUiOrientation uiOrientation =
                (orientation == ScreenOrientationLockPortrait) ? CAknAppUi::EAppUiOrientationPortrait
                    : CAknAppUi::EAppUiOrientationLandscape;
        CAknAppUi* appUi = dynamic_cast<CAknAppUi*> (CEikonEnv::Static()->AppUi());
        TRAPD(error,
            if (appUi)
                appUi->SetOrientationL(uiOrientation);
        );
        Q_UNUSED(error)
#else // ORIENTATIONLOCK
        qWarning("'ORIENTATIONLOCK' needs to be defined on Symbian when locking the orientation.");
#endif // ORIENTATIONLOCK
    }
#elif defined(Q_WS_MAEMO_5)
    Qt::WidgetAttribute attribute;
    switch (orientation) {
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_Maemo5PortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_Maemo5LandscapeOrientation;
        break;
    case ScreenOrientationAuto:
    default:
        attribute = Qt::WA_Maemo5AutoOrientation;
        break;
    }
    setAttribute(attribute, true);
#else // Q_OS_SYMBIAN
    Q_UNUSED(orientation);
#endif // Q_OS_SYMBIAN
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    showMaximized();
#else
    show();
#endif
}
