#ifndef MAFWDB_H
#define MAFWDB_H

#include <QtSql>
#include <QMap>
#include <QByteArray>
#include <QProgressDialog>


class MafwDb
{

public:

    MafwDb(bool firstopen);

    QSqlDatabase db;

    bool connectToMafwDb();

    void closeMafwDb();

    bool addStationsToMafwDb();

    bool deleteStationsFromMafwDb();

private:

    QMap<QString, QString> getRadioStationsList();

    bool insertRowIntoDatabase(int pID, QString pKey, QString pValue);

    bool addStation(QString pStationTitle, QString pURL);

    bool addStationFinal(int pID, QString pTitle, QString pURL);

    bool deleteStationByID(int pID);

    QByteArray buildBlob(QString pstr);

    QString decodeBlob(QByteArray pba);

    void setupProgDlg(int maxRange);

    QProgressDialog *progbar;
};

#endif // MAFWDB_H
