#include "mafwdb.h"


MafwDb::MafwDb(bool firstopen)
{
    if(firstopen)
    {
        db = QSqlDatabase::addDatabase("QSQLITE");
        db.setDatabaseName("/home/user/.mafw.db");
    }
    else
    {
        db = QSqlDatabase::database();
    }
}

bool MafwDb::connectToMafwDb()
{
    if (!db.open())
    {
        qDebug() << db.lastError();
        return false;
    }

    return true;
}

void MafwDb::closeMafwDb()
{
    db.close();
}

void MafwDb::setupProgDlg(int maxRange)
{
    progbar = new QProgressDialog(0, Qt::Dialog);
    progbar->reset();
    progbar->setLabelText("");
    progbar->setWindowTitle("Please wait");
    progbar->setRange(0,maxRange);
    progbar->setMinimumDuration(0);
    progbar->setAutoClose(true);
    progbar->setAutoReset(true);
    progbar->setCancelButton(false);
    progbar->show();
    QCoreApplication::processEvents();
}

bool MafwDb::addStationsToMafwDb()
{
    //Init progdlg
    setupProgDlg(100);

    QMap<QString, QString> map = getRadioStationsList();
    int e = 0, j = 0;
    QMapIterator<QString, QString> i(map);

    while(i.hasNext())
    {
        i.next();
        progbar->setValue((++j * 100)/(map.size()));
        if(!addStation("ARB - " + i.key(), i.value()))
            e++;
    }

    progbar->reset();

    if(e)
        return false;

    return true;
}

bool MafwDb::addStation(QString pStationTitle, QString pURL)
{
    int ID = 0;
    QSqlQuery query;

    query.prepare("Select * FROM iradiobookmarks where key  = 'title' AND value = ?");
    query.addBindValue(buildBlob(pStationTitle));
    query.exec();
    if(query.next())
        return true;

    query.prepare("Select * FROM iradiobookmarks where key  = 'title' AND value = ?");
    query.addBindValue(buildBlob("ARB - " + pStationTitle));
    query.exec();
    if(query.next())
        return true;

    query.exec("select max(id) from iradiobookmarks");

    while(query.next())
    {
        ID = query.value(0).toInt() + 1;
    }

    return addStationFinal(ID, pStationTitle, pURL);
}

bool MafwDb::addStationFinal(int pID, QString pTitle, QString pURL)
{
    insertRowIntoDatabase(pID, "title", pTitle);
    insertRowIntoDatabase(pID, "mime-type", "audio");
    insertRowIntoDatabase(pID, "uri", pURL);

    return insertRowIntoDatabase(pID, "x-added-by", "arabiciradio");
}

bool MafwDb::insertRowIntoDatabase(int pID, QString pKey, QString pValue)
{
    QSqlQuery query;
    query.prepare("INSERT INTO iradiobookmarks (id, key, value) VALUES (?, ?, ?)");
    query.addBindValue(pID);
    query.addBindValue(pKey);
    query.addBindValue(buildBlob(pValue));

    return query.exec();
}

bool MafwDb::deleteStationsFromMafwDb()
{
    QSqlQuery q;

    //Init progdlg
    setupProgDlg(0);

    q.prepare("Select * FROM iradiobookmarks where key  = 'x-added-by' AND value = ?");
    q.addBindValue(buildBlob("arabiciradio"));
    q.exec();

    if(q.executedQuery().isEmpty())
        return false;

    while(q.next())
    {
        QCoreApplication::processEvents();
        deleteStationByID(q.value(0).toInt());
    }

    progbar->reset();

    return true;
}

bool MafwDb::deleteStationByID(int pID)
{
    QSqlQuery q;
    return q.exec("DELETE FROM iradiobookmarks where id = '"+QString::number(pID)+"'");
}

//The format of the blob is "\x01\x00\x00\x00@\x00\x00\x00string that we want\x00"
QByteArray MafwDb::buildBlob(QString pstr)
{
    QByteArray ba;

    int i = 0;
    ba[i++] = 0x01;
    ba[i++] = 0x00;
    ba[i++] = 0x00;
    ba[i++] = 0x00;
    ba[i++] = '@';
    ba[i++] = 0x00;
    ba[i++] = 0x00;
    ba[i++] = 0x00;

    ba.append(pstr);
    ba[ba.size()] = 0x00;

    return ba;
}

QString MafwDb::decodeBlob(QByteArray pba)
{
    return pba.mid(8,pba.size());
}

//16-02-2011 (39)
QMap<QString, QString> MafwDb::getRadioStationsList()
{
    QMap<QString, QString> radioMap;

    radioMap.insert("Mazaj FM - Jordan","mms://radio.sama.jo/mazaj");
    radioMap.insert("Radio Rotana - Jordan","mms://stream.rotanaradio.fm/rotana32");
    radioMap.insert("Radio Jordan - Amman FM 99.0","mms://stream.jrtv.jo/radio2");
    radioMap.insert("AmmanNet 92.4 FM - Jordan","http://wma.str3am.com/ammannet");
    radioMap.insert("Swat-al-Madenah 88.7 FM - Jordan","mms://64.225.157.204/smadinafm-32");
    radioMap.insert("Sawt El Ghad - Jordan","mms://64.225.157.204/sawtfm1");
    radioMap.insert("Radio Amen FM 89.5 - Jordan","mms://213.139.32.2/amenfm");

    radioMap.insert("MBC FM","http://nms1.mbc.net/mbcfm1");

    radioMap.insert("Sawt Beirut","http://www.sawtbeirut.com/WindowsMediaPlayer.asx");
    radioMap.insert("Sawt El Mada","http://sem.netdesignplus.com/live.ram");
    radioMap.insert("Radio BeirutNights.com","http://images.listenarabic.com/asx/beirut_nights.ram");
    radioMap.insert("97.8 UAQ FM","http://asx.abacast.com/humfm-978uaqfm-32.asx");
    radioMap.insert("Radio Orient Live Stream","http://www.futuretvnetwork.com/mms2.asx");

    radioMap.insert("Aswat Radio - Morocco","http://broadcaster.infomaniak.ch/aswat-high.mp3");
    radioMap.insert("France Maghreb 2","http://broadcast.infomaniak.ch/francemaghreb2-high.mp3");
    radioMap.insert("Chada FM - Morocco","http://broadcast.infomaniak.ch/chadafm-high.mp3");
    radioMap.insert("Radio HabayiiB - Morocco","http://212.117.175.48:20073");
    radioMap.insert("Radio Yabiladi Morocco","http://media.yabiladi.com:8000/");
    radioMap.insert("Sawa 101.0 FM - Morocco","http://www.radiosawa.com/livestreams/radiosawanafr.asx");
    radioMap.insert("RFI Arabic - Monte Carlo Doualiya","http://gisv3.tv-radio.com/station/monte-carlo-doualiya-mp3/monte-carlo-doualiya-mp3-128k.asx");

    radioMap.insert("Almadina FM Syria","http://www.almadinafm.com/streaming_player/WMstreaming.asx");
    radioMap.insert("Arabesque FM Syria","http://91.144.0.79:80/arabesque");
    radioMap.insert("Mix FM Syria","http://mixfmsyria.com:8020/");
    radioMap.insert("Al Bishara Aleppo - Syria","http://www.radioalbishara.org/radioalbishara.pls");

    radioMap.insert("Radio Siraj 105.5 FM - Palestine","http://radio.ttawor.com:8001");
    radioMap.insert("Radio Bethlehem 2000","http://radiobethlehem2000.net/Live.m3u");
    radioMap.insert("Marah FM 100.5 - Palestine","http://omardes.org:8062/");
    radioMap.insert("NAGHAM FM - Palestine","http://www.radionagham.com/live/winamp.pls");
    radioMap.insert("Radio Mawwal 101.7 FM - Palestine","mms://mawwalfm.no-ip.biz:1017/");
    radioMap.insert("Iman Radio 96.2 FM - Palestine","http://www.imanradio.com/file.asx");

    radioMap.insert("Marina FM 88.8 Kuwait","http://asx.abacast.com/marinafm-marinafm-32.asx");
    radioMap.insert("Kuwait 92.5 FM","mms://62.215.162.163:7777");

    radioMap.insert("Radio Cairo","http://live.sis.gov.eg/live");
    radioMap.insert("Horytna.net Cairo","mms://196.205.121.43/horytna");
    radioMap.insert("Radio Sawa Egypt","http://bbgvoa.edgeboss.net/wmedia-live/bbgvoa/58527/32_bbgvoa-sawaegypt_090429.asx");

    radioMap.insert("Radio Al Manar Belgium","http://www.musicgoal.com/radio-station/stream/1000033797/mediaplayer.asx?e6973c0f44763758f08807711bf7f25c");

    radioMap.insert("Islah TV - KSA","mms://66.172.3.142/3");

    radioMap.insert("Radio Sawa - Iraq","http://www.radiosawa.com/livestreams/radiosawaiq.asx");

    radioMap.insert("Radio Sanaa","http://www.yradio.gov.ye/programs/news.ra");


    return radioMap;
}
