#include "mainwindow.h"


MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    firstInstance = true;

    actAbout = new QAction(tr("About"), this);
    connect(actAbout, SIGNAL(triggered()),this, SLOT(showAbout()));
    menuBar()->addAction(actAbout);

    central = new QWidget(this);

    glay = new QGridLayout(central);

    buttonAddAll = new QPushButton();
    buttonAddAll->setText("Add arabic stations");
    buttonAddAll->setFont(QFont("Nokia Sans", 20, QFont::Normal));

    buttonDelAll = new QPushButton();
    buttonDelAll->setText("Delete arabic stations");
    buttonDelAll->setFont(QFont("Nokia Sans", 20, QFont::Normal));

    QSpacerItem *spacerItem = new QSpacerItem(0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);

    glay->addItem(spacerItem,0,0);
    glay->addWidget(buttonAddAll,1,0);
    glay->addWidget(buttonDelAll,2,0);
    central->setLayout(glay);
    setCentralWidget(central);

    //Background Image
    QPalette palette;
    QPixmap pixmap(":/images/main.png");
    palette.setBrush(backgroundRole(), pixmap);
    setPalette(palette);

    //Slots
    connect(buttonAddAll, SIGNAL(clicked()), this, SLOT(slotAddAllStations()));
    connect(buttonDelAll, SIGNAL(clicked()), this, SLOT(slotDelAllStations()));
}

void MainWindow::showAbout()
{
    QMaemo5InformationBox::information(this,
        tr("<br>arabiciradio v0.3<br>Is a little application that adds arabic stations to the media player.<br>Developed by Raed A using Qt, email: raedbenz@hotmail.com<br>"),
        QMaemo5InformationBox::NoTimeout);
}

void MainWindow::slotAddAllStations()
{
    mafwdb = new MafwDb( firstInstance );
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
    QCoreApplication::processEvents();

    //Connect to DB
    if(mafwdb->connectToMafwDb())
    {
        firstInstance = false;

        //Add stations
        if(mafwdb->addStationsToMafwDb())
        {
            QMaemo5InformationBox::information(this,
                tr("<br>Stations were added successfully!<br>Go to Media player to start listening.<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
        else
        {
            QMaemo5InformationBox::information(this,
                tr("<br><font color='red'>Operation failed.<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
    }
    else
    {
        QMaemo5InformationBox::information(this,
            tr("<br><font color='red'>Operation failed.<br>Make sure Media player is closed.<br>"),
            QMaemo5InformationBox::NoTimeout);
    }

    //Close DB
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
    mafwdb->closeMafwDb();
    delete mafwdb;
}

void MainWindow::slotDelAllStations()
{
    mafwdb = new MafwDb( firstInstance );
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
    QCoreApplication::processEvents();

    //Connect to DB
    if(mafwdb->connectToMafwDb())
    {
        firstInstance = false;

        //Delete Stations
        if(mafwdb->deleteStationsFromMafwDb())
        {
            QMaemo5InformationBox::information(this,
                tr("<br>Arabic stations were deleted successfully!<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
        else
        {
            QMaemo5InformationBox::information(this,
                tr("<br><font color='red'>Operation failed.<br>"),
                QMaemo5InformationBox::NoTimeout);
        }
    }
    else
    {
        QMaemo5InformationBox::information(this,
            tr("<br><font color='red'>Operation failed.<br>Make sure Media player is closed.<br>"),
            QMaemo5InformationBox::NoTimeout);
    }

    //Close DB
    //setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
    mafwdb->closeMafwDb();
    delete mafwdb;
}


MainWindow::~MainWindow()
{

}
