#!/usr/bin/env python

import sys
import optparse
import re
import string
import os
import time
import gtk
import commands
import hildon
import ConfigParser
import osso
import dbus
import dbus.service
import gobject

# Global constants
#os.environ["SDL_VIDEO_X11_WMCLASS"]="appinstaller"
osso_c = osso.Context("appinstaller", "0.0.1", False)

bus = dbus.SessionBus()
searchproxy = bus.get_object('org.freedesktop.Tracker','/org/freedesktop/Tracker/Search')
metadataproxy=bus.get_object('org.freedesktop.Tracker','/org/freedesktop/Tracker/Metadata')
print "dbus set"
                    
class appinstaller(hildon.Program):
    def __init__(self):
        global config
        hildon.Program.__init__(self)
        self.saveOn=True
        self.window = hildon.Window()
        self.window.connect("destroy", gtk.main_quit)  
        self.add_window(self.window)
        self.selectedFile=""
        
        self.textBuff = gtk.TextBuffer(None)
        self.textBuff.set_text("Select debian from the list to install")
        #self.textBuff.set_text(commands.getoutput("lsusb"))
        self.textArea = gtk.TextView(self.textBuff)
        
                                                                             
        pannable_area = hildon.PannableArea()        
        vbox = gtk.VBox(spacing=12)
        
        pannable_area.add_with_viewport(vbox)
        self.window.add(pannable_area)
        
        #vbox.pack_start  (gtk.Label ("installing"), expand=True, fill=True)
        vbox.pack_start  (self.apply_button, expand=True, fill=True)
                                                   
        
        query='<rdfq:Condition><rdfq:inSet><rdfq:Property name="File:Mime" /><rdf:String>application/x-deb</rdf:String></rdfq:inSet></rdfq:Condition>'
        print query         
        metadata=searchproxy.Query(-1, "Files", ["File:Name","File:Path"],"", dbus.Array([], signature='s') ,query,False,["File:Added"], True,0, 40000)
        #We get a nice list sorted by artist
        
                                                                                    
        table = gtk.Table (3, 2, False)                                                               
        table.set_col_spacings (30)                                                                   
        table.set_row_spacings (30)
        
        
        i=0   
        for debFile in metadata:                        
            fileUrl=debFile[0]
            fileName=debFile[2]
            table.attach (gtk.Label (fileName),               0, 1, i, i+1)
            installButton = gtk.Button("Install")
            installButton.connect("clicked", self.testInstall, fileUrl)
            table.attach (installButton,                      1, 2, i, i+1)
            i=i+1        
        
            print fileUrl
            self.filecombobox.append_text(fileUrl)
                
        vbox.pack_start  (table, expand=True, fill=True)
        vbox.pack_start  (self.textArea, expand=True, fill=True)
        vbox.show()
        

    def testInstall(self, widget, fileUrl):
        print "installing test: dpkg -i "+fileUrl
        
        devs = commands.getoutput("dpkg -i "+fileUrl)
        
        sdevs = devs.rsplit('\n')
        self.textBuff.set_text(devs)
        print sdevs
                
                
                
    def run(self):     
        self.window.show_all()
        gtk.main() 

if __name__ == "__main__":      
    app = appinstaller()
    app.run()
    print sys.argv         
