#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include "ApplicationList.h"
#include "subwindow.h"
#include "categorylistwidget.h"
#include <QtGui/QMainWindow>
#include <QList>
#include "loadwidget.h"
#include "categoryview.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
    Q_DISABLE_COPY(MainWindow)
public:
    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();



public slots:
    void sendSearchRequest ();
    void goHome();
    void goBackToList ();
    void removeUpperLayer();
    void addWidgetLayer(QWidget*,QString,QString);
    void setBreadCrumbs (QString,QString,bool setDefault=false);
    void errorHandler (QString);

private slots:
    void openListView (int);
    void showPromoDetails ();
    void receivedPromoted (QList<MaemoApplication*>*);
    void promoPreviewReceived(QPixmap*,QString,QString);
    void receivedPromotedAppDetails(MaemoApplicationDetails*);

private:
    enum buttons {FRESHEST,CATEGORY,DOWNLOAD,RATING};
    Ui::MainWindow *m_ui;
    QList <SubWindow*> *topWidgets;
    QList <SubWindow*> *buffer;
    CategoryListWidget *categoryList;
    MaemoApplicationHandler *handler;
    MaemoApplicationDetails *promoApp;
    QPushButton *promotedButton;
    QString DEFAULTBC1;
    QString DEFAULTBC2;
    LoadWidget *loading;
    QButtonGroup *buttonGroup;



};

#endif // MAINWINDOW_H
