#include "applicationcommentswidget.h"
#include "ui_applicationcommentswidget.h"
#include <QListWidgetItem>



ApplicationCommentsWidget::ApplicationCommentsWidget(MaemoApplicationDetails *app,MaemoApplicationHandler* handler,  QWidget *parent) :
    QWidget(parent),
    m_ui(new Ui::ApplicationCommentsWidget)
{
    m_ui->setupUi(this);
    m_ui->backgroundFrame->setStyleSheet ("background-color: black");
    m_ui->userFrame->setStyleSheet("background-color: black;border:none;");
    m_ui->statusBarFrame->setStyleSheet ("background-image: url(:/images/background/bar.png);");
    m_ui->iconLabel->setStyleSheet ("background-image: url(:/images/icons/default-icon.png);background-repeat: no-repeat;");
    applicationHandler = handler;
    appDetails = app;
    comments = app->getUserComments();
    preload = 10;
    more = true;
    if (preload >= comments->length()) {
        more = false;
        preload = comments->length();
    }
    for (int i=0;i < preload; i++) {
        item = new QListWidgetItem (m_ui->commentsListWidget);
        comment = new CommentItemWidget (comments->at(i));
        m_ui->commentsListWidget->setItemWidget(item,comment);
        item->setSizeHint(comment->size());
    }
    QString username = applicationHandler->userName();
    if (!username.isEmpty()) {
        m_ui->statusLabel->setText(username);
        m_ui->loginButton->setText("Logout");
        m_ui->commentButton->setText ("Comment");
        m_ui->commentButton->setEnabled(true);
        disconnect (m_ui->loginButton,SIGNAL(clicked()),this,SLOT(loginPrompt()));
        connect (m_ui->loginButton,SIGNAL(clicked()),this,SLOT(logout()));
    } else {
        m_ui->commentButton->setText ("Please login to comment");
        m_ui->commentButton->setEnabled(false);
    }

}

ApplicationCommentsWidget::~ApplicationCommentsWidget()
{
    delete m_ui;
}

void ApplicationCommentsWidget::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ApplicationCommentsWidget::loadAllComments () {
    if (more) {
        int i;
        for (i=preload;i < comments->length(); i++) {
            item = new QListWidgetItem (m_ui->commentsListWidget);
            comment = new CommentItemWidget (comments->at(i));
            m_ui->commentsListWidget->setItemWidget(item,comment);
            item->setSizeHint(comment->size());
        }
    }
}

void ApplicationCommentsWidget::commentApplication () {
    commentApp = new CommentingWidget (applicationHandler,this->appDetails->getName(),COMMENTING,parentWidget());
    commentApp->show();
    connect (commentApp,SIGNAL(deleteWidget(int)),this,SLOT(closeWindow(int)));
}

void ApplicationCommentsWidget::updateStatus(QString uname) {
    if (uname.isEmpty()) {
        m_ui->statusLabel->setText("offline");
        m_ui->loginButton->setText("Login");
        m_ui->commentButton->setText ("Please login to comment");
        m_ui->commentButton->setEnabled(false);
        disconnect (m_ui->loginButton,SIGNAL(clicked()),this,SLOT(logout()));
        connect (m_ui->loginButton,SIGNAL(clicked()),this,SLOT(loginPrompt()));
    } else {
        m_ui->statusLabel->setText(uname);
        m_ui->loginButton->setText("Logout");
        m_ui->commentButton->setText ("Comment");
        m_ui->commentButton->setEnabled(true);
        disconnect (m_ui->loginButton,SIGNAL(clicked()),this,SLOT(loginPrompt()));
        connect (m_ui->loginButton,SIGNAL(clicked()),this,SLOT(logout()));
    }
}


void ApplicationCommentsWidget::loginPrompt()
{
    login = new LoginPrompt (applicationHandler,LOGIN,this->parentWidget());
    login->setGeometry(0,0,800,480);
    login->show();
    connect (login,SIGNAL(loggedIn(QString)),this,SLOT(updateStatus(QString)));
    connect (login,SIGNAL(deleteWidget(int)),this,SLOT(closeWindow(int)));
}

void ApplicationCommentsWidget::logout() {
    applicationHandler->logOut();
    this->updateStatus("");
}

void ApplicationCommentsWidget::closeWindow (int w) {
    if (w==LOGIN) {
        disconnect (login,SIGNAL(deleteWidget(int)),this,SLOT(closeWindow(int)));
        qDebug()<<"login";
        delete login;
    }
    else if (w==COMMENTING) {
        disconnect (commentApp,SIGNAL(deleteWidget(int)),this,SLOT(closeWindow(int)));
        qDebug()<<"commenting";
        delete commentApp;
    }
}

void ApplicationCommentsWidget::isUserLoggedIn(int l) {
    qDebug ()<<l;
}
