#ifndef APPLICATIONDETAILSWIDGET_H
#define APPLICATIONDETAILSWIDGET_H

#include <QtGui/QWidget>
#include <QPixmap>
#include <QTextStream>

#include "applicationcommentswidget.h"
#include "appdownloader-comm/MaemoApplicationDetails.h"
#include "appdownloader-comm/MaemoApplicationHandler.h"

namespace Ui {
    class ApplicationDetailsWidget;
}

class ApplicationDetailsWidget : public QWidget {
    Q_OBJECT
    Q_DISABLE_COPY(ApplicationDetailsWidget)
public:
    explicit ApplicationDetailsWidget(MaemoApplicationDetails *, MaemoApplicationHandler*,QWidget *parent = 0);
    virtual ~ApplicationDetailsWidget();

public slots:
    void addScreenshot (QPixmap *,QString, QString);
    void installApplication ();
    void openComments();
    void widgetLayerAdded (QWidget*,QString,QString);

signals:
    void layerAdded (QWidget *,QString,QString);

protected:
    virtual void changeEvent(QEvent *e);

private:
    Ui::ApplicationDetailsWidget *m_ui;
    MaemoApplicationDetails *application;
    MaemoApplicationHandler *applicationHandler;
    int screenshotPosition;
};

#endif // APPLICATIONDETAILSWIDGET_H
