#include "ApplicationList.h"
#include <QWidget>
#include <QVariant>
#include <QFrame>
#include <QDebug>


ApplicationList::ApplicationList (MaemoApplicationHandler *handler, QWidget *parent): QWidget  (parent) {
    busy=false;
    extended = false;
    loadingActive = false;
    appHandler = handler;
    appListWidgets = new QList <ApplicationListWidget*> ();
    main = parent;
    this->setFixedSize (800,426);
    unreceivedPreviews = 0;
    QFrame *backgroundFrame = new QFrame (this);
    backgroundFrame->setStyleSheet("background-color: black");
    backgroundFrame->setGeometry(0,0,800,372);
    loading = new LoadWidget (this);
    loading->setGeometry (375,161,50,50);
    loading->startLoading();

    //statusbar
    statusBar = new QWidget (this);
    statusBar->setStyleSheet ("background-image: url(:/images/background/bar.png)");
    statusBar->setGeometry (0,372,800,54);
    moreButton = new QPushButton ("more...",statusBar);
    moreButton->setGeometry(640,5,150,45);
    moreButton->setStyleSheet (":flat{color: white; font-family: \"NokiaSans\"; background-color: none; border: none; background-image: url(:/images/background/install_bar.png);}");
    moreButton->setFlat(true);
    connect (moreButton,SIGNAL(clicked()),this,SLOT(expand()));
    moreButton->setVisible (false);
}

ApplicationList::~ApplicationList () {
    int a;
    for (a = 0; a < appListWidgets -> length (); a++) {
          delete appListWidgets->at(a);
    }
    if (!loading) {
        delete this->appList;
    }
    delete statusBar;
    appHandler->emptyQueue();
    //delete this->appListWidgets;
}

void ApplicationList::requestApplications (int listType,QString OS,QString cat, int page, int pageSize, QString search,QString sort) {
    extended = false;
    connect (appHandler, SIGNAL(applicationListReady(QList<MaemoApplication*>*)),this,SLOT(listDelivered(QList<MaemoApplication*>*)));
    if (busy) {
        // notification
    } else {
        QTextStream out (stdout);
        busy = true;
        type = listType;
        req = new RestRequest (OS,cat,page,pageSize,search,sort);
        appHandler->requestApplications (req);
    }
}

void ApplicationList::expand() {
    qDebug () << "before" << req->page() << req ->pageSize();
    moreButton->setDisabled(true);
    loading = new LoadWidget (statusBar);
    loading->setStyleSheet("background-image: url(''); border:none;");
    loading->startLoading();
    loading->setGeometry(10,0,50,50);
    loading->show();
    req->nextPage();
    qDebug () << "after" << req->page() << req ->pageSize();
    extended = true;
    connect (appHandler, SIGNAL(applicationListReady(QList<MaemoApplication*>*)),this,SLOT(listDelivered(QList<MaemoApplication*>*)));
    appHandler->requestApplications(req);
}


/* slot when the list is delivered
 * show list of available applications in window
 * @todo: limit -> next, prev page */
void ApplicationList::listDelivered(QList <MaemoApplication *> *maemoAppList) {
    // delete old list if it existed
    disconnect (appHandler, SIGNAL(applicationListReady(QList<MaemoApplication*>*)),this,SLOT(listDelivered(QList<MaemoApplication*>*)));

    if (maemoAppList->length() > 0) {
        qDebug () << "maemoAppList->length() > 0";
        if (!extended) {
            qDebug () << "!extended";
            if (appListWidgets->length ()>0) {
                for (int a = 0; a < appListWidgets -> length (); a++) {
                    delete appListWidgets->at(a);
                }
                appListWidgets = new QList <ApplicationListWidget*> ();
                delete appList;
                appList = new QListWidget (this);
                appList->setGeometry (0,0,800,372);
            } else {
                appList = new QListWidget (this);
                appList->setGeometry (0,0,800,372);
            }
        }

        qDebug () << extended;

        appList->setHorizontalScrollBarPolicy (Qt::ScrollBarAlwaysOff);
        QTextStream out (stdout);
        ApplicationListWidget *app;
        QListWidgetItem *item;
        int length = maemoAppList->length();
        if (length==15) {
            moreButton->setEnabled(true);
            moreButton->setVisible(true);
        } else {
            moreButton->setVisible(false);
        }
        connect (appHandler, SIGNAL( imageReady (QPixmap*,QString,QString)),this,SLOT(previewImageDelivered(QPixmap*,QString,QString)));
        for (int a = 0; a < length; a++) {
            app = new ApplicationListWidget(maemoAppList->at(a));
            //connect (app, SIGNAL(clicked(bool,MaemoApplication*)),this,SLOT(appButtonClicked(bool,MaemoApplication*)));
            out << maemoAppList->at(a)->toString() << endl;
            appListWidgets -> append (app);
            item = new QListWidgetItem();
            item->setSizeHint(QSize(800,120));
            item->setData (APPID,QVariant(maemoAppList->at(a)->getUid()));
            item->setData (APPWIDGET,QVariant(appListWidgets->indexOf(app)));
            int index = appListWidgets->indexOf(app);
            qDebug () << "index: " << index;
            appList->addItem(item);
            qDebug () << "widget index" << appList->count();
            appList->setItemWidget (item, app);
            if (!(maemoAppList->at(a)->getPreview()).isEmpty()) {
                qDebug() << maemoAppList->at(a)->getPreview();
                appHandler->requestImage(maemoAppList->at(a)->getPreview(),QString::number(index),"LIST",true);
                unreceivedPreviews ++;
            }
            else {
                out << "without: "+maemoAppList->at(a)->getTitle()<<endl;
            }
        }
        if (unreceivedPreviews==0) {
            disconnect (appHandler, SIGNAL( imageReady (QPixmap*,QString,QString)),this,SLOT(previewImageDelivered(QPixmap*,QString,QString)));
        }
        connect (appList, SIGNAL(itemClicked(QListWidgetItem *)),this,SLOT(appButtonClicked(QListWidgetItem*)));
        //connect (appList, SIGNAL(itemPressed(QListWidgetItem*)),this,SLOT(appButtonPressed(QListWidgetItem*)));
        appList->show();
        loading->stopLoading();
        delete loading;
        busy = false;
    } else {
        //loading->setText("Unfortunately no application found.");
    }
    delete maemoAppList;

}

void ApplicationList::previewImageDelivered(QPixmap * pre, QString id, QString type) {
    QTextStream out (stdout);
    if (type=="LIST") {
        appListWidgets->at(id.toInt())->setPreview(new QPixmap(pre->scaled(195,117)));
        unreceivedPreviews --;

        if (unreceivedPreviews==0) {
            disconnect (appHandler, SIGNAL( imageReady (QPixmap*,QString,QString)),this,SLOT(previewImageDelivered(QPixmap*,QString,QString)));
        }
    }
}

//open window with application details
void ApplicationList::singleAppDelivered(MaemoApplicationDetails *app) {
    loadingActive = false;
    disconnect (appHandler,SIGNAL(applicationDetailsReady(MaemoApplicationDetails*)),this,SLOT(singleAppDelivered(MaemoApplicationDetails*)));
    ApplicationDetailsWidget *appDetails = new ApplicationDetailsWidget (app,appHandler,main);
    appDetails->setGeometry (0,54,800,426);
    connect (appDetails,SIGNAL(layerAdded(QWidget*,QString,QString)),this,SLOT(widgetLayerAdded(QWidget*,QString,QString)));
    emit layerAdded(appDetails,app->getTitle(),"");
    loading->stopLoading();
    delete loading;
    appDetails->show();

}

void ApplicationList::appButtonPressed(QListWidgetItem *item) {
    //appListWidgets->at(item->data(APPWIDGET).toInt())->select();
}

void ApplicationList::widgetLayerAdded(QWidget * w,QString bc1,QString bc2) {
    emit layerAdded(w,bc1,bc2);
}


//application button is clicked
//-> request details
void ApplicationList::appButtonClicked (QListWidgetItem *item) {
    if (!loadingActive) {
        loadingActive = true;
        loading = new LoadWidget (statusBar);
        loading->setStyleSheet("background-image: url(''); border:none;");
        loading->startLoading();
        loading->setGeometry(10,0,50,50);
        loading->show();
    }
    appList->setCurrentItem (item);
    appHandler->requestApplicationData(item->data(APPID).toString());

    //appListWidgets->at(item->data(APPWIDGET).toInt())->unselect();
    connect (appHandler,SIGNAL(applicationDetailsReady(MaemoApplicationDetails*)),this,SLOT(singleAppDelivered(MaemoApplicationDetails*)));
}



void ApplicationList::refetchData(bool) {
    //appHandler->requestAllApplications();
}

// is called, when a connection couldn't be established
// updates the window with this information
void ApplicationList::connectionError() {
}


