#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QScrollArea>
#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    m_ui(new Ui::MainWindow)
{
    m_ui->setupUi(this);

    //handler = new MaemoApplicationHandler("nokes.nokia.com",8080);
    handler = new MaemoApplicationHandler();

    loading = new LoadWidget (m_ui->freshestFrame);
    loading->startLoading();

    handler->requestApplications("Maemo5","",1,1,"","new");
    connect (handler,SIGNAL(applicationListReady(QList<MaemoApplication*>*)),this,SLOT(receivedPromoted(QList<MaemoApplication*>*)));
    //categoryList = new CategoryListWidget (m_ui->mainWidget);
    //connect (categoryList, SIGNAL (itemClicked(QListWidgetItem*)),this, SLOT(openApplicationsList(QListWidgetItem*)));
    topWidgets = new QList <SubWindow*>();

    //*topBarWidget*//
    m_ui->topBarWidget->setStyleSheet ("background-image: url(:/images/background/bar.png);");

    //button settings of topBar
    m_ui->closeButton->setStyleSheet (":flat{image: url(:/images/icons/cross.png);background-color: none; border: none;}");

    //settings of topBar-labels
    m_ui->breadcrumb2Label->setStyleSheet ("color: white; border:none;font-family: \"NokiaSans\";");
    m_ui->breadcrumb1Label->setStyleSheet ("color: white; border:none;font-family: \"NokiaSans\";");
    m_ui->logoButton->setStyleSheet ("background-image: url(:/images/icons/maemo.png);border:none;");
    m_ui->firstSeparatorLabel->setStyleSheet ("background-image: url(:/images/icons/bar_arrow.png);border:none;background-repeat: no-repeat");
    m_ui->secondSeparatorLabel->setStyleSheet ("background-image: url(:/images/icons/bar_arrow.png);border:none;background-repeat: no-repeat");

    //*statusBarWidget*//
    m_ui->statusBarWidget->setStyleSheet ("background-image: url(:/images/background/bar.png);");

    //buttons"color: white; border:none;font-family: \"NokiaSans\";"
    m_ui->searchButton->setStyleSheet (":flat{color: white; font-family: \"NokiaSans\"; background-color: none; border: none; background-image: url(:/images/background/install_bar.png);}");
    m_ui->backButton->setVisible(false);
    m_ui->backButton->setStyleSheet (":flat{image: url(:/images/icons/back_arrow.png);background-color: none; border: none;}");
    m_ui->label->setStyleSheet("background-image: url(:/images/background/separator_mainview.png);border:none;");

    m_ui->keywordLineEdit->setFrame(false);
    m_ui->searchFrame->setStyleSheet ("background-color: white;background-image: url("");");

    DEFAULTBC1="Maemo 5";
    DEFAULTBC2="";
    setBreadCrumbs("","",true);

}


MainWindow::~MainWindow()
{
    delete m_ui;
}

void MainWindow::receivedPromoted(QList<MaemoApplication*>* promos) {
    disconnect (handler,SIGNAL(applicationListReady(QList<MaemoApplication*>*)),this,SLOT(receivedPromoted(QList<MaemoApplication*>*)));
    if (promos->length()>0) {
        MaemoApplication *app = promos->takeFirst();
        delete promos;
        qDebug() << app->getPreview();
        handler->requestApplicationData(app->getUid());
        connect (handler, SIGNAL(applicationDetailsReady(MaemoApplicationDetails*)),this,SLOT(receivedPromotedAppDetails(MaemoApplicationDetails*)));
        handler->requestImage(app->getBigPreview(),"promoted");
        connect (handler,SIGNAL(imageReady(QPixmap*,QString,QString)),this,SLOT(promoPreviewReceived(QPixmap*,QString,QString)));
    }

}

void MainWindow::receivedPromotedAppDetails(MaemoApplicationDetails* promotedAppDetails) {
    qDebug() << "***************************";
    disconnect (handler, SIGNAL(applicationDetailsReady(MaemoApplicationDetails*)),this,SLOT(receivedPromotedAppDetails(MaemoApplicationDetails*)));

    QLabel *desc = new QLabel (promotedAppDetails->getDescription(),m_ui->freshestFrame);
    qDebug() << promotedAppDetails->getDescription();
    QLabel *title = new QLabel (promotedAppDetails->getTitle(),m_ui->freshestFrame);
    title->setFixedSize(237,45);
    title->setStyleSheet("color: white; font: 18px;font-family: \"NokiaSans\";background-color: none;");
    title->setGeometry(5,155,247,40);
    title->setWordWrap(true);
    title->setAlignment (Qt::AlignTop);
    title->show();
    desc->setFixedSize(237,217);
    desc->setGeometry(5,205,247,172);
    desc->setStyleSheet("color: #999999; font: 16px;font-family: \"NokiaSans\";");
    desc->setAlignment (Qt::AlignTop);
    qDebug()<<"*"<<desc->text()<<"*";
    desc->setWordWrap(true);
    desc->show();
    QLabel *fade = new QLabel (m_ui->freshestFrame);
    fade->setFixedSize(247,20);
    fade->setStyleSheet("background-image: url(:/images/icons/fade.png);border:none;background-color:none;");
    fade->setGeometry(0,352,247,20);
    fade->show();
}

void MainWindow::promoPreviewReceived(QPixmap* screenshot,QString id,QString) {
    if (id=="promoted") {
        disconnect (handler,SIGNAL(imageReady(QPixmap*,QString,QString)),this,SLOT(promoPreviewReceived(QPixmap*,QString,QString)));
        QLabel *preview = new QLabel (m_ui->freshestFrame);
        preview->setPixmap(screenshot->scaled(247,148,Qt::IgnoreAspectRatio,Qt::SmoothTransformation));
        preview->show();
        QLabel *feat = new QLabel (m_ui->freshestFrame);
        feat->setStyleSheet("background-image: url(:/images/icons/featured.png);border:none;background-color:none;");
        feat->setFixedSize(247,40);
        feat->setGeometry(0,0,247,40);
        feat->show();
    }

}

void MainWindow::openApplicationsList(QListWidgetItem *item) {
    ApplicationList *applicationList = new ApplicationList (handler,m_ui->centralwidget);

    applicationList -> requestApplications (ApplicationList::ALL,
                                            item->data(CategoryListWidget::MAEMOVERSION).toString(),
                                            item->data(CategoryListWidget::CATEGORY).toString(),
                                            item->data(CategoryListWidget::PAGE).toInt(),
                                            item->data(CategoryListWidget::PAGESIZE).toInt(),
                                            "",
                                            item->data(CategoryListWidget::SORTING).toString());
    applicationList->setGeometry(0,54,800,426);
    connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
    applicationList->show();
    addWidgetLayer (applicationList,"Maemo 5",item->data(CategoryListWidget::TITLE).toString());
}

void MainWindow::openTopTenDown() {
    ApplicationList *applicationList = new ApplicationList (handler,this);

    applicationList -> requestApplications (ApplicationList::ALL,"Maemo5","",1,10,"","down");
    applicationList->setGeometry(0,54,800,426);
    connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
    applicationList->show();
    addWidgetLayer (applicationList,"Maemo 5","Top 10");
}

void MainWindow::openTopTenRate() {
    ApplicationList *applicationList = new ApplicationList (handler,this);

    applicationList -> requestApplications (ApplicationList::ALL,"Maemo5","",1,10,"","high");
    applicationList->setGeometry(0,54,800,426);
    connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
    applicationList->show();
    addWidgetLayer (applicationList,"Maemo 5","Top 10");
}

void MainWindow::openTopTenFresh() {
    ApplicationList *applicationList = new ApplicationList (handler,this);
    applicationList -> requestApplications (ApplicationList::ALL,"Maemo5","",1,10,"","new");
    applicationList->setGeometry(0,54,800,426);
    connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
    applicationList->show();
    addWidgetLayer (applicationList,"Maemo 5","Top 10");
}

void MainWindow::openCategoryView() {
    CategoryView *view = new CategoryView (handler,this);
    view->setGeometry(0,54,800,426);
    addWidgetLayer (view,"Maemo 5","Categories");
    connect (view, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
    view->show();

}

void MainWindow::sendSearchRequest () {
    QString k = m_ui->keywordLineEdit->text();
    ApplicationList *applicationList = new ApplicationList (handler,m_ui->centralwidget);
    applicationList->requestApplications (ApplicationList::ALL,"Maemo5","",0,999,k);
    addWidgetLayer (applicationList,"Maemo 5","Search: "+k);
    applicationList->setGeometry(0,54,800,426);
    connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
    applicationList->show();
}

void MainWindow::goHome () {
    //applicationList->requestApplications (ApplicationList::HOTTEST,"Maemo5","",0,10,"","down");
}

void MainWindow::addWidgetLayer (QWidget* w, QString bc1, QString bc2) {
    if (topWidgets->length()==0) {
        m_ui->backButton->setVisible(true);
    }
    topWidgets->append(new SubWindow (w,bc1,bc2));
    setBreadCrumbs(bc1,bc2);
}

void MainWindow::removeUpperLayer() {
    if (topWidgets->length()>0) {
        delete topWidgets->takeLast();
    }
    if (topWidgets->length()==0) {
        m_ui->backButton->setVisible(false);
        setBreadCrumbs("","",true);
    }
    else {
        setBreadCrumbs(topWidgets->last()->getBreadcrumb_1(),topWidgets->last()->getBreadcrumb_2());
    }
}

void MainWindow::setBreadCrumbs (QString bc1, QString bc2, bool setDefault) {

    if (setDefault) {
        bc1= DEFAULTBC1;
        bc2= DEFAULTBC2;
    }
    m_ui->breadcrumb1Label->setText(bc1);
    int width = m_ui->breadcrumb1Label->fontMetrics().width(bc1);
    m_ui->breadcrumb1Label->setFixedSize (width,54);
    if (bc2.isEmpty()) {
        m_ui->secondSeparatorLabel->setVisible (false);
    } else {
        m_ui->secondSeparatorLabel->setVisible (true);
        m_ui->secondSeparatorLabel->setGeometry (150+width,0,20,54);
    }
    m_ui->breadcrumb2Label->setText(bc2);
    m_ui->breadcrumb2Label->setFixedSize(m_ui->breadcrumb1Label->fontMetrics().width(bc2),54);
    m_ui->breadcrumb2Label->setGeometry (190+width,0,20,54);
}

void MainWindow::goBackToList () {
    int k;
    for (k=0;k<topWidgets->length();k++) {
        delete topWidgets->at(k);
    }
    delete topWidgets;
    topWidgets = new QList <SubWindow*>();
}

