#include "loginprompt.h"
#include "ui_loginprompt.h"
#include <QDebug>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif



LoginPrompt::LoginPrompt(MaemoApplicationHandler *handler,QWidget *parent) :
    QWidget(parent),
    ui(new Ui::LoginPrompt)
{
    ui->setupUi(this);
    applicationHandler = handler;
}

LoginPrompt::~LoginPrompt()
{
    delete ui;
}

void LoginPrompt::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void LoginPrompt::userLogin() {
    if (!ui->passwordLineEdit->text().isNull()&&!ui->userNameLineEdit->text().isNull()) {
        username = ui->userNameLineEdit->text();
        applicationHandler->requestLogin (username,ui->passwordLineEdit->text());
        connect (applicationHandler,SIGNAL(loggedIn(int)),this,SLOT(loginResponse(int)));
    }
}

void LoginPrompt::loginResponse(int res) {
    disconnect (applicationHandler,SIGNAL(loggedIn(int)),this,SLOT(loginResponse(int)));
    qDebug () << res;
    if (res == MaemoApplicationHandler::LoggedIn) {
        qDebug () << "Login successful";
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(parentWidget(),"\n"+username+", you are logged in successfully!\n");
        #endif
        emit loggedIn (username);
        this->close();
    }
    else if (res == MaemoApplicationHandler::LoggedInCredentialsError) {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this,"\nWrong credentials!\n");
        #endif
        qDebug () << "wrong credentials";
    }
    else {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this,"\nConnection Error! Please try again!\n");
        #endif
        qDebug () << "connection error";
    }
}
