#ifndef APPLICATIONCOMMENTSWIDGET_H
#define APPLICATIONCOMMENTSWIDGET_H

#include <QtGui/QWidget>
#include <QList>
#include <QListWidgetItem>

#include "appdownloader-comm/MaemoApplicationHandler.h"
#include "appdownloader-comm/MaemoApplicationDetails.h"
#include "appdownloader-comm/MaemoComment.h"
#include "commentitemwidget.h"

namespace Ui {
    class ApplicationCommentsWidget;
}

class ApplicationCommentsWidget : public QWidget {
    Q_OBJECT
    Q_DISABLE_COPY(ApplicationCommentsWidget)

public:
    explicit ApplicationCommentsWidget(MaemoApplicationDetails*,MaemoApplicationHandler*,QWidget *parent = 0);
    virtual ~ApplicationCommentsWidget();
    void loadAllComments ();

public slots:
    void commentApplication();
    void isUserLoggedIn (int);
    void updateStatus (QString);
    void loginPrompt();
    void logout();

signals:
    void layerAdded(QWidget*,QString,QString);


protected:
    virtual void changeEvent(QEvent *e);


private:


    Ui::ApplicationCommentsWidget *m_ui;
    MaemoApplicationDetails *appDetails;
    QList <MaemoComment*>* comments;
    CommentItemWidget *comment;
    QListWidgetItem *item;
    int preload;
    bool more;
    MaemoApplicationHandler *applicationHandler;



};

#endif // APPLICATIONCOMMENTSWIDGET_H
