#ifndef RATINGLABEL_H
#define RATINGLABEL_H

#include <QLabel>
#include <QHBoxLayout>
#include <QPushButton>
#include <QButtonGroup>

class RatingLabel : public QLabel  {
    Q_OBJECT

    public:
        // create rating label with number of rating [0,5]
        RatingLabel (int rating=0, QWidget *parent=0, bool active=false);
        ~RatingLabel ();
        void setBackgroundColor (QString);
        int rating ();

    public slots:
        void changeRating (int);

    private:
        QString empty;
        QString filled;
        QHBoxLayout *layout;
        QButtonGroup *group;
        int value;

    };
#endif // RATINGLABEL_H


