#include "RatingLabel.h"

RatingLabel::RatingLabel (int rating, QWidget *parent, bool active) : QLabel (parent) {
    //initialize
    value = rating;
    filled = "images/icons/star_filled.png";
    empty = "images/icons/star_empty.png";
    layout = new QHBoxLayout();
    group = new QButtonGroup (this);
    if (!active) {
        if (rating > 0 && rating <= 5) {
            //set filled icons
            for (int i=0;i<rating;i++) {
                QLabel *s = new QLabel(this);
                s->setStyleSheet("background-image: url(:/"+filled+");background-repeat: no-repeat; border: none;");
                s->setFixedSize(26,40);
                s->setGeometry(i*26,11,26,40);
            }
            //set empty icons
            for (int i=rating;i<5;i++) {
                QLabel *s = new QLabel(this);
                s->setStyleSheet("background-image: url(:/"+empty+");background-repeat: no-repeat; border: none;");
                s->setFixedSize(26,40);
                s->setGeometry(i*26,11,26,40);
            }
        }
        // if not rated show just empty icons
        else {
            for (int i=0;i<5;i++) {
                QLabel *s = new QLabel(this);
                s->setStyleSheet("background-image: url(:/"+empty+");background-repeat: no-repeat; border: none;");
                s->setFixedSize(26,40);
                s->setGeometry(i*26,11,26,40);
            }
        }
        this->setLayout(layout);

        //preconfigured settings
        this->setFixedSize (130,40);
        this->setStyleSheet( "color: #424345; background-color: none; border: none;");
    }
    else {


        if (rating > 0 && rating <=5) {
            for (int i=0;i<rating;i++) {
                QPushButton *pb = new QPushButton(this);
                pb->setStyleSheet("flat:{background-image: url(); border: none;}");
                pb->setIcon(QIcon(QString("/opt/appdownloader/images/icons/star_filled.png")));
                pb->setGeometry(i*120,0,120,54);
                pb->setFlat(true);
                group->addButton(pb,i+1);
            }
            for (int i=rating; i<5; i++) {
                QPushButton *pb = new QPushButton(this);
                pb->setStyleSheet(":flat{background-image: url(); border: none;}");
                pb->setIcon(QIcon(QString("/opt/appdownloader/images/icons/star_empty.png")));
                pb->setGeometry(i*120,0,120,54);
                pb->setFlat(true);
                group->addButton(pb,i+1);
            }

        }
        else {
            for (int i=0;i<5;i++) {
                QPushButton *pb = new QPushButton(this);
                pb->setStyleSheet(":flat{background-image: url();; border: none;}");
                pb->setIcon(QIcon(QString("/opt/appdownloader/images/icons/star_empty.png")));
                pb->setGeometry(i*120,0,120,54);
                pb->setFlat(true);
                group->addButton(pb,i+1);
            }
        }
        connect (group,SIGNAL(buttonClicked(int)),this,SLOT(changeRating(int)));
        this->setFixedSize (600,54);
        this->setStyleSheet( "background-image: url(); border: none;");
    }
}

RatingLabel::~RatingLabel() {
    delete layout;
    delete group;
}

void RatingLabel::changeRating(int butID) {
    value = butID;
    for (int i=0;i<value;i++) {
        group->button(i+1)->setIcon(QIcon(QString("/opt/appdownloader/images/icons/star_filled.png")));

    }
    for (int i=value; i<5; i++) {
        group->button(i+1)->setIcon(QIcon(QString("/opt/appdownloader/images/icons/star_empty.png")));
    }
}


int RatingLabel::rating () {
    return value;
}

void RatingLabel::setBackgroundColor (QString colorCode) {
    this->setStyleSheet( "background-color: "+colorCode+"; border: none;");
}
