#include "applicationlistwidget.h"
#include "ui_applicationlistwidget.h"

ApplicationListWidget::ApplicationListWidget(MaemoApplication *app,QWidget *parent) :
    QWidget(parent),
    m_ui(new Ui::ApplicationListWidget)
{
    m_ui->setupUi(this);
    this->application = app;
    m_ui->appName->setText(app->getTitle());
    m_ui->appName->setStyleSheet ("color:#F48802;background-color:black;background-image:url("");font-family: \"NokiaSans\";");
    ratingLabel = new RatingLabel (application->getRating().left(1).toInt(),m_ui->ratingWidget);
    m_ui->downloadsLabel->setStyleSheet ("color: #858689;font-family: \"NokiaSans\";");
    m_ui->downloadsNumberLabel->setStyleSheet ("color:white;font-family: \"NokiaSans\";");
    m_ui->downloadsNumberLabel->setText (application->getDownloads());
    m_ui->downloadsLabel->setStyleSheet ("color: #858689;font-family: \"NokiaSans\";");
    m_ui->contributersLabel->setStyleSheet ("color: #858689;background-image:url("");font-family: \"NokiaSans\";");
    m_ui->contributersNameLabel->setStyleSheet ("color: white;background-image:url("");font-family: \"NokiaSans\";");
    m_ui->contributersNameLabel->setText(app->getPersonId());
    m_ui->widgetFrame->setFixedSize (800,120);
    m_ui->widgetFrame->setStyleSheet("background-image: url(:/images/background/list.png); border:none;");
    m_ui->previewLabel->setStyleSheet("background-image: url(:/images/icons/no_logo.png);border:none;background-repeat: no-repeat;");
    //m_ui->previewLabel->setPixmap(QString("images/icons/no_logo.png"));
    this->setFixedSize(800,120);
}

void ApplicationListWidget::setPreview(QPixmap *preview) {
    m_ui->previewLabel->setPixmap(*preview);
    m_ui->previewLabel->setStyleSheet("background-image: url("");border:none;");
}

void ApplicationListWidget::select() {
    m_ui->appName->setStyleSheet ("color:red;background-color:black;background-image:url("");");
}

void ApplicationListWidget::unselect() {
    m_ui->appName->setStyleSheet ("color:#F48802;background-color:black;background-image:url("");");
}


ApplicationListWidget::~ApplicationListWidget()
{
    delete m_ui;
}

void ApplicationListWidget::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
