#ifndef APPLICATIONLIST_H
#define APPLICATIONLIST_H

#include <QWidget>
#include <QList>
#include <QFrame>
#include <QPushButton>
#include <QListWidget>
#include <QLineEdit>
#include <QMainWindow>

#include "appdownloader-comm/MaemoApplication.h"
#include "appdownloader-comm/restrequest.h"
#include "applicationlistwidget.h"
#include "applicationdetailswidget.h"
#include "loadwidget.h"

class ApplicationList : public QWidget {
Q_OBJECT

public:
        ApplicationList (MaemoApplicationHandler *handler, QWidget *parent=0);
        virtual ~ApplicationList();
        void requestApplications (int, QString,QString, int, int, QString,QString="");

public slots:
        void refetchData (bool);
        void expand ();
        void listDelivered (QList <MaemoApplication *>*);
        void singleAppDelivered (MaemoApplicationDetails*);
        void connectionError ();
        void previewImageDelivered (QPixmap*,QString,QString);
        void widgetLayerAdded (QWidget*,QString,QString);

private slots:
        void appButtonClicked (QListWidgetItem*);
        void appButtonPressed (QListWidgetItem*);


signals:
        void layerAdded (QWidget*,QString,QString);

public:
        enum ListType {HOTTEST,ALL,TWOCOLUMNS};
        enum ListItemRoles { APPID = Qt::UserRole, APPWIDGET = Qt::UserRole + 1};

private:
        QWidget *main;
        LoadWidget *loading;
        QListWidget *appList;
        QWidget *statusBar;
        QFrame *searchFrame;
        QPushButton *moreButton;
        RestRequest *req;

        MaemoApplicationHandler *appHandler;
        QList <ApplicationListWidget*> *appListWidgets;
        bool extended;
        bool busy;
        bool loadingActive;
        int type;
        int selectedItem();
        int unreceivedPreviews;
};
#endif // APPLICATIONLIST_H
