#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QScrollArea>
#include <QDebug>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif
MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    m_ui(new Ui::MainWindow)
{
    m_ui->setupUi(this);
    #ifdef Q_WS_MAEMO_5
        handler = new MaemoApplicationHandler();
    #else
        handler = new MaemoApplicationHandler("nokes.nokia.com",8080,10);
        qDebug ("proxy");
    #endif

    connect (handler,SIGNAL (raiseError(QString)),this,SLOT(errorHandler(QString)));

    loading = new LoadWidget (m_ui->freshestFrame);
    loading->setGeometry(98,161,50,50);
    loading->startLoading();

    handler->requestApplications("Maemo5","",0,1,"","high");
    connect (handler,SIGNAL(applicationListReady(QList<MaemoApplication*>*)),this,SLOT(receivedPromoted(QList<MaemoApplication*>*)));
    //categoryList = new CategoryListWidget (m_ui->mainWidget);
    topWidgets = new QList <SubWindow*>();

    //*topBarWidget*//
    m_ui->topBarWidget->setStyleSheet ("background-image: url(:/images/background/bar.png);");

    //button settings of topBar
    m_ui->closeButton->setStyleSheet (":flat{image: url(:/images/icons/cross.png);background-color: none; border: none;}");

    //settings of topBar-labels
    m_ui->breadcrumb2Label->setStyleSheet ("color: white; border:none;font-family: \"NokiaSans\";");
    m_ui->breadcrumb1Label->setStyleSheet ("color: white; border:none;font-family: \"NokiaSans\";");
    m_ui->logoButton->setStyleSheet ("background-image: url(:/images/icons/maemo.png);border:none;");
    m_ui->firstSeparatorLabel->setStyleSheet ("background-image: url(:/images/icons/bar_arrow.png);border:none;background-repeat: no-repeat");
    m_ui->secondSeparatorLabel->setStyleSheet ("background-image: url(:/images/icons/bar_arrow.png);border:none;background-repeat: no-repeat");

    //*statusBarWidget*//
    m_ui->statusBarWidget->setStyleSheet ("background-image: url(:/images/background/bar.png);");

    //buttons"color: white; border:none;font-family: \"NokiaSans\";"
    m_ui->searchButton->setStyleSheet (":flat{color: white; font-family: \"NokiaSans\"; background-color: none; border: none; background-image: url(:/images/background/install_bar.png);}");
    m_ui->backButton->setVisible(false);
    m_ui->backButton->setStyleSheet (":flat{image: url(:/images/icons/back_arrow.png);background-color: none; border: none;}");
    m_ui->label->setStyleSheet("background-image: url(:/images/background/separator_mainview.png);border:none;");

    m_ui->keywordLineEdit->setFrame(false);
    m_ui->searchFrame->setStyleSheet ("background-color: white;background-image: url("");");

    buttonGroup = new QButtonGroup(this);
    buttonGroup->addButton(m_ui->freshestButton,FRESHEST);
    buttonGroup->addButton(m_ui->categoriesButton,CATEGORY);
    buttonGroup->addButton(m_ui->downloadsButton,DOWNLOAD);
    buttonGroup->addButton(m_ui->ratingButton,RATING);

    for (int i=0;i<buttonGroup->buttons().length();i++) {
        buttonGroup->buttons().at(i)->setEnabled(false);
    }
    m_ui->searchButton->setEnabled(false);
    connect (buttonGroup,SIGNAL(buttonClicked(int)),this,SLOT(openListView(int)));

    DEFAULTBC1="Maemo 5";
    DEFAULTBC2="";
    setBreadCrumbs("","",true);

}


MainWindow::~MainWindow()
{
    delete m_ui;
}

void MainWindow::errorHandler(QString error) {
    qDebug () << "start error handling";
    #ifdef Q_WS_MAEMO_5
        qDebug () << "show error msg!";
        QMaemo5InformationBox::information(m_ui->centralwidget,error+"\nPlease try again!\n");
    #else
        qDebug () << "error";
    #endif
}

void MainWindow::receivedPromoted(QList<MaemoApplication*>* promos) {
    qDebug () << "reveive Promoted";
    for (int i=0;i<buttonGroup->buttons().length();i++) {
        buttonGroup->buttons().at(i)->setEnabled(true);
    }
    m_ui->searchButton->setEnabled(true);
    disconnect (handler,SIGNAL(applicationListReady(QList<MaemoApplication*>*)),this,SLOT(receivedPromoted(QList<MaemoApplication*>*)));
    if (promos->length()>0) {
        MaemoApplication *app = promos->takeFirst();
        delete promos;
        qDebug() << app->getPreview();
        handler->requestApplicationData(app->getUid());
        connect (handler, SIGNAL(applicationDetailsReady(MaemoApplicationDetails*)),this,SLOT(receivedPromotedAppDetails(MaemoApplicationDetails*)));
        if (!app->getBigPreview().isEmpty()) {
            handler->requestImage(app->getBigPreview(),"promoted");
            connect (handler,SIGNAL(imageReady(QPixmap*,QString,QString)),this,SLOT(promoPreviewReceived(QPixmap*,QString,QString)));
        } else {
            delete loading;
            QLabel *feat = new QLabel (m_ui->freshestFrame);
            feat->setStyleSheet("background-image: url(:/images/icons/featured.png);border:none;background-color:none;");
            feat->setFixedSize(247,40);
            feat->setGeometry(0,0,247,40);
            feat->show();
        }
    } else {
        loading->stopLoading();
        delete loading;
        QLabel *errorLabel = new QLabel (m_ui->freshestFrame);
        errorLabel->setStyleSheet("color: #999999; font: 16px;font-family: \"NokiaSans\";");
        errorLabel->setGeometry(5,0,247,372);
        errorLabel->setWordWrap (true);
        errorLabel->setText("No preview available.");
        errorLabel->setAlignment(Qt::AlignCenter);
        errorLabel->show();
    }

}

void MainWindow::receivedPromotedAppDetails(MaemoApplicationDetails* promotedAppDetails) {
    qDebug() << "***************************";
    disconnect (handler, SIGNAL(applicationDetailsReady(MaemoApplicationDetails*)),this,SLOT(receivedPromotedAppDetails(MaemoApplicationDetails*)));
    loading->stopLoading();
    delete loading;

    QLabel *desc = new QLabel (promotedAppDetails->getDescription(),m_ui->freshestFrame);
    qDebug() << promotedAppDetails->getDescription();
    QLabel *title = new QLabel (promotedAppDetails->getTitle(),m_ui->freshestFrame);
    title->setFixedSize(237,45);
    title->setStyleSheet("color: white; font: 18px;font-family: \"NokiaSans\";background-color: none;");
    title->setGeometry(5,155,247,40);
    title->setWordWrap(true);
    title->setAlignment (Qt::AlignTop);
    title->show();
    desc->setFixedSize(237,217);
    desc->setGeometry(5,205,247,172);
    desc->setStyleSheet("color: #999999; font: 16px;font-family: \"NokiaSans\";");
    desc->setAlignment (Qt::AlignTop);
    qDebug()<<"*"<<desc->text()<<"*";
    desc->setWordWrap(true);
    desc->show();
    QLabel *fade = new QLabel (m_ui->freshestFrame);
    fade->setFixedSize(247,20);
    fade->setStyleSheet("background-image: url(:/images/icons/fade.png);border:none;background-color:none;");
    fade->setGeometry(0,352,247,20);
    fade->show();

    promoApp = promotedAppDetails;
    promotedButton = new QPushButton (m_ui->freshestFrame);
    promotedButton->setStyleSheet("background-color: none;background-image:url();border:none;");
    promotedButton->setFixedSize(247,372);
    promotedButton->setGeometry(0,0,247,372);
    promotedButton->setEnabled(true);
    connect (promotedButton,SIGNAL(clicked()),this,SLOT(showPromoDetails()));
    promotedButton->show();
}

void MainWindow::showPromoDetails() {
    qDebug () << "*** showpromodetails ***";
    ApplicationDetailsWidget *appDetails = new ApplicationDetailsWidget (promoApp,handler,this);
    appDetails->setGeometry (0,54,800,426);
    connect (appDetails,SIGNAL(layerAdded(QWidget*,QString,QString)),this,SLOT(addWidgetLayer(QWidget*,QString,QString)));
    addWidgetLayer (appDetails,promoApp->getTitle(),"");
    appDetails->show();
}

void MainWindow::promoPreviewReceived(QPixmap* screenshot,QString id,QString) {
    if (id=="promoted") {
        disconnect (handler,SIGNAL(imageReady(QPixmap*,QString,QString)),this,SLOT(promoPreviewReceived(QPixmap*,QString,QString)));
        QLabel *preview = new QLabel (m_ui->freshestFrame);
        preview->setPixmap(screenshot->scaled(247,148,Qt::IgnoreAspectRatio,Qt::SmoothTransformation));
        preview->show();
        QLabel *feat = new QLabel (m_ui->freshestFrame);
        feat->setStyleSheet("background-image: url(:/images/icons/featured.png);border:none;background-color:none;");
        feat->setFixedSize(247,40);
        feat->setGeometry(0,0,247,40);
        feat->show();
        promotedButton->raise();
    }

}


void MainWindow::openListView(int buttonid) {
    if (buttonid!=CATEGORY) {
        ApplicationList *applicationList = new ApplicationList (handler,this);
        QString sortmode="";
        QString title;
        switch (buttonid) {
        case FRESHEST:
            sortmode = "new";
            title = "Freshest updates";
            break;
        case DOWNLOAD:
            sortmode = "down";
            title = "Most downloaded";
            break;
        case RATING:
            sortmode = "high";
            title = "Best rated";
            break;
        }
        applicationList -> requestApplications (ApplicationList::ALL,"Maemo5","",1,10,"",sortmode);
        applicationList->setGeometry(0,54,800,426);
        connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
        applicationList->show();
        addWidgetLayer (applicationList,"Maemo 5",title);
    }
    else {
        CategoryView *view = new CategoryView (handler,this);
        view->setGeometry(0,54,800,426);
        addWidgetLayer (view,"Maemo 5","Categories");
        connect (view, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
        view->show();
    }

}


void MainWindow::sendSearchRequest () {
    QString k = m_ui->keywordLineEdit->text();
    ApplicationList *applicationList = new ApplicationList (handler,m_ui->centralwidget);
    applicationList->requestApplications (ApplicationList::ALL,"Maemo5","",0,999,k);
    addWidgetLayer (applicationList,"Maemo 5","Search: "+k);
    applicationList->setGeometry(0,54,800,426);
    connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(addWidgetLayer(QWidget*,QString,QString)));
    applicationList->show();
}

void MainWindow::goHome () {
    //applicationList->requestApplications (ApplicationList::HOTTEST,"Maemo5","",0,10,"","down");
}

void MainWindow::addWidgetLayer (QWidget* w, QString bc1, QString bc2) {
    if (topWidgets->length()==0) {
        m_ui->backButton->setVisible(true);
    }
    topWidgets->append(new SubWindow (w,bc1,bc2));
    setBreadCrumbs(bc1,bc2);
}

void MainWindow::removeUpperLayer() {
    if (topWidgets->length()>0) {
        delete topWidgets->takeLast();
    }
    if (topWidgets->length()==0) {
        m_ui->backButton->setVisible(false);
        setBreadCrumbs("","",true);
    }
    else {
        setBreadCrumbs(topWidgets->last()->getBreadcrumb_1(),topWidgets->last()->getBreadcrumb_2());
    }
}

void MainWindow::setBreadCrumbs (QString bc1, QString bc2, bool setDefault) {

    if (setDefault) {
        bc1= DEFAULTBC1;
        bc2= DEFAULTBC2;
    }
    m_ui->breadcrumb1Label->setText(bc1);
    int width = m_ui->breadcrumb1Label->fontMetrics().width(bc1);
    m_ui->breadcrumb1Label->setFixedSize (width,54);
    if (bc2.isEmpty()) {
        m_ui->secondSeparatorLabel->setVisible (false);
    } else {
        m_ui->secondSeparatorLabel->setVisible (true);
        m_ui->secondSeparatorLabel->setGeometry (150+width,0,20,54);
    }
    m_ui->breadcrumb2Label->setText(bc2);
    m_ui->breadcrumb2Label->setFixedSize(m_ui->breadcrumb1Label->fontMetrics().width(bc2),54);
    m_ui->breadcrumb2Label->setGeometry (190+width,0,20,54);
}

void MainWindow::goBackToList () {
    int k;
    for (k=0;k<topWidgets->length();k++) {
        delete topWidgets->at(k);
    }
    delete topWidgets;
    topWidgets = new QList <SubWindow*>();
}

