#include "loginprompt.h"
#include "ui_loginprompt.h"
#include <QDebug>
#include <QInputContext>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif



LoginPrompt::LoginPrompt(MaemoApplicationHandler *handler,int w,QWidget *parent) :
    QWidget(parent),
    ui(new Ui::LoginPrompt)
{
    ui->setupUi(this);
    ui->saveItCheckBox->setVisible(false);
    ui->userNameLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase);
    id=w;
    applicationHandler = handler;
}

LoginPrompt::~LoginPrompt()
{
    delete ui;
}

void LoginPrompt::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void LoginPrompt::userLogin() {
    if (!ui->passwordLineEdit->text().isEmpty()&&!ui->userNameLineEdit->text().isEmpty()) {
        loading = new LoadWidget (ui->topStatusBarFrame);
        loading->setStyleSheet("background-image:url();border:none;");
        loading->setGeometry(720,2,50,50);
        loading->startLoading();
        loading->show();
        username = ui->userNameLineEdit->text();
        applicationHandler->requestLogin (username,ui->passwordLineEdit->text());
        connect (applicationHandler,SIGNAL(loggedIn(int)),this,SLOT(loginResponse(int)));
    }
    else {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this,"\nPlease provide username and password!\n");
        #endif
    }
}

void LoginPrompt::loginResponse(int res) {
    disconnect (applicationHandler,SIGNAL(loggedIn(int)),this,SLOT(loginResponse(int)));
    delete loading;
    qDebug () << res;
    if (res == MaemoApplicationHandler::LoggedIn) {
        qDebug () << "Login successful";
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(parentWidget(),"\n"+username+", you are logged in successfully!\n");
        #endif
        emit loggedIn (username);
        emit deleteWidget (id);
    }
    else if (res == MaemoApplicationHandler::LoggedInCredentialsError) {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this,"\nWrong credentials!\n");
        #endif
        qDebug () << "wrong credentials";
    }
    else {
        #ifdef Q_WS_MAEMO_5
            QMaemo5InformationBox::information(this,"\nConnection Error! Please try again!\n");
        #endif
        qDebug () << "connection error";
    }
}

void LoginPrompt::closeWidget() {
    this->close();
    emit deleteWidget (id);
}
