#ifndef CATEGORYVIEW_H
#define CATEGORYVIEW_H

#include <QWidget>
#include "ApplicationList.h"


namespace Ui {
    class CategoryView;
}

class CategoryView : public QWidget {
    Q_OBJECT
public:
    explicit CategoryView(MaemoApplicationHandler *h, QWidget *parent = 0);
    ~CategoryView();

public slots:
    void widgetLayerAdded (QWidget*,QString,QString);

protected:
    void changeEvent(QEvent *e);
    void requestList (QString categoryID, QString categoryName);

protected slots:
    void requestGames();
    void requestDesktop();
    void requestMultimedia ();
    void requestNavigation ();
    void requestInternet ();
    void requestTools ();
    void requestGraphics ();
    void requestDevelopment ();
    void requestOffice ();
    void requestSystem ();
    void requestOther ();

signals:
    void layerAdded (QWidget*,QString,QString);

private:
    Ui::CategoryView *ui;
    MaemoApplicationHandler *handler;
};

#endif // CATEGORYVIEW_H
