#include "categoryview.h"
#include "ui_categoryview.h"

CategoryView::CategoryView(MaemoApplicationHandler *h, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::CategoryView)
{
    ui->setupUi(this);
    handler = h;
}

CategoryView::~CategoryView()
{
    delete ui;
}

void CategoryView::requestGames() {
    requestList ("cbd3f29aa75511dea50b6b332998fac1fac1","Games");
}

void CategoryView::requestDesktop() {
    requestList ("fe94a4d2a75411de9faf73d7e4c5d995d995","Desktop");
}

void CategoryView::requestMultimedia () {
    requestList ("e1266ab0a75511de9a80b5f5ad0d70857085","Multimedia");
}

void CategoryView::requestNavigation () {
    requestList ("f64736d6a75511deb661fd6d059b6cfa6cfa","Navigation");
}

void CategoryView::requestInternet () {
    requestList ("aed5066ea74811dea4f6b11b7fd004f204f2","Internet");
}

void CategoryView::requestTools () {
    requestList ("2e9375b6a74911de8298bfef9cd654ca54ca","Tools");
}

void CategoryView::requestGraphics () {
    requestList ("95263bdea74811de8b78fb138dec3c333c33","Graphics");
}

void CategoryView::requestDevelopment () {
    requestList ("2086ed3ca74811dea27603f75ad7dbc5dbc5","Development");
}

void CategoryView::requestOffice () {
    requestList ("c1dd9ce4a74811de94606d394a0a9bc69bc6","Office");
}

void CategoryView::requestSystem () {
    requestList ("71cdfb32a75611de8369a9e58d3f0c370c37","System");
}

void CategoryView::requestOther () {
    requestList ("47b9b53ca74911de8f7f2940d8a6574a574a","Other");
}

void CategoryView::requestList (QString categoryID,QString categoryName) {
    ApplicationList *applicationList = new ApplicationList (handler,parentWidget());
    applicationList -> requestApplications (ApplicationList::ALL,"Maemo5",categoryID,1,15,"","down");
    applicationList->setGeometry(0,54,800,426);
    connect (applicationList, SIGNAL (layerAdded (QWidget*,QString,QString)),this, SLOT(widgetLayerAdded(QWidget*,QString,QString)));
    applicationList->show();
    emit layerAdded (applicationList,"Categories",categoryName);
}

void CategoryView::widgetLayerAdded(QWidget *w,QString bc1, QString bc2) {
    emit layerAdded (w,bc1,bc2);
}

void CategoryView::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
