# -*- coding: utf-8 -*-
import curses.ascii
import urllib

from PyQt4 import QtGui
from PyQt4 import QtCore

from PyQt4.QtCore import QFile,  QIODevice
from PyQt4.QtMaemo5 import QMaemo5InformationBox

from ui.appFolders import MainWindow

from classes.folderContent import FolderContent
from classes.folderList import FolderList

import resources_rc

class FolderName(Exception):
    
    def __init__(self, value):
        self.value = value
        
    def __str__(self):
        return repr(self.value)

class MainApp():
    
    def __init__ (self,  parent = None):
        
        self.folderlist = FolderList()
        self.foldercontent = FolderContent(self.folderlist)
    
    def getFileNameFromName(self,  input):
        try:
            input = unicode(input)
            input = input.encode("ascii")
        except:
            raise FolderName("Not Ascii")
        
        output = ""
        f = False
        for j in input:
                if curses.ascii.isalnum(j) or j == "-" or j =="_":
                   output = output + j
                elif j == " " or j == "\\" or j == "/":
                   output = output + "_"
                else:
                    raise FolderName("Special")
        
        output = urllib.quote_plus(output)
        return output
        
    def readDirectoryTemplate(self):
        templateFile = QFile(":/resources/dirFolder.txt")
        templateFile.open(QIODevice.ReadOnly)
        template = templateFile.readData(templateFile.size())
        templateFile.close()
        return template
        
    def readMenuTemplate(self):
        templateFile = QFile(":/resources/menuFolder.txt")
        templateFile.open(QIODevice.ReadOnly)
        template = templateFile.readData(templateFile.size())
        templateFile.close()
        return template
        
    def readHildonMenuTemplate(self):
        templateFile = QFile(":/resources/hildonMenu.txt")
        templateFile.open(QIODevice.ReadOnly)
        template = templateFile.readData(templateFile.size())
        templateFile.close()
        return template
        
    def readReadme(self):
        readmeFile = QFile(":/resources/readme.txt")
        readmeFile.open(QIODevice.ReadOnly)
        readme = readmeFile.readData(readmeFile.size())
        readmeFile.close()
        return readme
        
    def readWarning(self):
        readmeFile = QFile(":/resources/warning.txt")
        readmeFile.open(QIODevice.ReadOnly)
        readme = readmeFile.readData(readmeFile.size())
        readmeFile.close()
        return readme
        
    def showInfoPopup(self,  target,  text):
        QMaemo5InformationBox.information(target, text)
    
