# -*- coding: utf-8 -*-
import string

from PyQt4 import QtGui
from PyQt4 import QtCore
from PyQt4.QtGui import QIcon,  QListWidgetItem,  QProgressDialog
from PyQt4.QtCore import QDir,  QStringList,  QString

from ui.dialogSelectFile import DialogSelectFile

class FolderList():
    
    IconpathLocal = "home/user/.local/share/icons/hicolor/48x48/hildon/"
    IconpathGlobal = "/usr/share/icons/hicolor/48x48/hildon/"
    DirpathLocal = "/home/user/.local/share/applications/hildon/"
    DirpathGlobal = "/usr/share/applications/hildon/"
    Menupath = "/home/user/.config/menus/submenus/"
    
    def __init__(self):
        self.nameref = {}
        self.selFile = ""
    
    def setFileName(self,  filename):
        self.selFile= filename
    
    def selectFile(self):
        
        dialog = DialogSelectFile(self)
        
        self.readFilenames()
        for index in self.nameref:
            dialog.listFile.addItem(index)
        
        dialog.show()
        dialog.exec_()
        
        selected = self.selFile
        self.selFile = ""
        return selected
    
    def selectIcon(self,  parent = None):

        dialog = DialogSelectFile(self)
        dialog.setWindowTitle("Select Icon")
        
        progress = QtGui.QProgressDialog("Please wait while loading icons", "Hide", 0, 100, parent)
        progress.setWindowModality(QtCore.Qt.WindowModal)
        progress.setAutoReset(True)
        progress.setAutoClose(True)
        progress.setMinimum(0)
        progress.setMaximum(100)
        progress.setWindowTitle("Loading...")
        progress.show()
        
        progress.setValue(0)

        directoryLocal = QDir(self.IconpathLocal)
        directoryLocal.setFilter(QDir.Files | QDir.Hidden | QDir.NoSymLinks);
        directoryLocal.setNameFilters(QStringList("*.png"))
        
        directoryGlobal = QDir(self.IconpathGlobal)
        directoryGlobal.setFilter(QDir.Files | QDir.Hidden | QDir.NoSymLinks);
        directoryGlobal.setNameFilters(QStringList("*.png"))
    
        for file in directoryLocal.entryList():
            icon = QIcon(self.IconpathLocal + file)
            part = string.split(file, '.png')[0]
            listItem = QListWidgetItem(icon,  part,  dialog.listFile,  QListWidgetItem.UserType)
            
        progress.setValue(50)
            
        for file in directoryGlobal.entryList():
            icon = QIcon(self.IconpathGlobal + file)
            part = string.split(file, '.png')[0]
            listItem = QListWidgetItem(icon,  part,   dialog.listFile,  QListWidgetItem.UserType)
            
        progress.setValue(100)
#        progress.hide()
        
        dialog.show()
        dialog.exec_()
        
        selected = self.selFile
        self.selFile = ""
        return selected
    
    def getNameFromDirFile(self, input):
        inputFile = open(input)
        filetxt = inputFile.read()
        filetxt = filetxt.split("Name=")[1]
        filetxt = filetxt.split("\n")[0]
        if  filetxt == "":
            part = string.split(input,  '/')[-1]
            part = string.split(part, '.directory')[0]
        else:
            part = filetxt
        inputFile.close()
        return part
    
    def getIconFromDirFile(self, input):
        inputFile = open(input)
        filetxt = inputFile.read()
        splitIcon = filetxt.split("Icon=")
        
        if len(splitIcon) <= 1:
            return
        
        filetxt = splitIcon[1]
        filetxt = filetxt.split("\n")[0]
        inputFile.close()
        
        if filetxt == "":
            return
        part = filetxt
        return part
    
    def readFilenames(self):
        self.nameref.clear()
        
        directoryLocal = QDir(self.DirpathLocal)
        directoryLocal.setFilter(QDir.Files | QDir.Hidden | QDir.NoSymLinks);
        directoryLocal.setNameFilters(QStringList("*.directory"))
        
        directoryGlobal = QDir(self.DirpathGlobal)
        directoryGlobal.setFilter(QDir.Files | QDir.Hidden | QDir.NoSymLinks);
        directoryGlobal.setNameFilters(QStringList("*.directory"))
    
        for file in directoryGlobal.entryList():
            part = self.getNameFromDirFile(self.DirpathGlobal + file)
            self.nameref[part] = self.DirpathGlobal + file
        for file in directoryLocal.entryList():
            part = self.getNameFromDirFile(self.DirpathLocal + file)
            self.nameref[part] = self.DirpathLocal + file
