# -*- coding: utf-8 -*-

"""
Module implementing MainWindow.
"""
import os

from PyQt4.QtGui import QMainWindow,  QIcon,  QListWidgetItem
from PyQt4.QtCore import pyqtSignature,  QString

from Ui_appFolders import Ui_MainWindow

class MainWindow(QMainWindow, Ui_MainWindow):
    
    hildonMenuPath = "/home/user/.config/menus/hildon.menu"
    
    """
    Class documentation goes here.
    """
    def __init__(self, mainApp,  parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.mainApp = mainApp
    
    @pyqtSignature("")
    def on_btnDelNameSelect_released(self):
        """
        Slot documentation goes here.
        """            
        filename = self.mainApp.folderlist.selectFile()
        if not filename == "":
            self.inpDelName.setText(str(filename))
    
    @pyqtSignature("")
    def on_btnDelete_released(self):
        """
        Slot documentation goes here.
        """
        if not self.inpDelName.text():
            self.mainApp.showInfoPopup(self, "Please select a folder first!")
            return
        
        self.mainApp.folderlist.readFilenames()
        try:
            dirFileName = self.mainApp.folderlist.nameref[str(self.inpDelName.text())]
        except:
            self.mainApp.showInfoPopup(self, "Could not find directory!")
            
        folderName = dirFileName.split("/")[-1]
        folderName = folderName.split(".directory")[0]
        menuFileName = self.mainApp.folderlist.Menupath + folderName + ".menu"
        
        os.remove(dirFileName)
        try:
            os.remove(menuFileName)
            self.mainApp.showInfoPopup(self, "Your folder was successfully removed!")
        except:
            self.mainApp.showInfoPopup(self, "Your folder was removed, but could not find menu entry!")
    
    @pyqtSignature("")
    def on_btnEditNameSelect_released(self):
        """
        Slot documentation goes here.
        """
        filename = self.mainApp.folderlist.selectFile(self)
        if not filename == "":
            self.inpEditName.setText(str(filename))
    
    @pyqtSignature("")
    def on_btnIconSelect_released(self):
        """
        Slot documentation goes here.
        """
        filename = self.mainApp.folderlist.selectIcon()
        if not filename == "":
            self.inpIcon.setText(str(filename))
    
    @pyqtSignature("")
    def on_btnCreate_released(self):
        """
        Slot documentation goes here.
        """
        if not self.inpEditName.text() or not  self.inpIcon.text():
            self.mainApp.showInfoPopup(self, "Please enter both name and icon!")
            return
            
        self.mainApp.folderlist.readFilenames()
            
        isNew = True
           
        if str(self.inpEditName.text()) in self.mainApp.folderlist.nameref:
            dirFileName = self.mainApp.folderlist.nameref[str(self.inpEditName.text())]
            folderName = dirFileName.split("/")[-1]
            folderName = folderName.split(".directory")[0]
            isNew = False
        else:
            try:
                folderName = self.mainApp.getFileNameFromName(self.inpEditName.text())
                dirFileName = self.mainApp.folderlist.DirpathLocal + folderName + ".directory"
            except:
                self.mainApp.showInfoPopup(self, "Please note that folder names are restricted " \
                                          + "to letters, numbers, spaces and the following " \
                                          + "special characters:\n - _ \\ /")
                return
            
        dirFileText = self.mainApp.readDirectoryTemplate()
        dirFileText = dirFileText.replace('%%name%%',  self.inpEditName.text())
        dirFileText = dirFileText.replace('%%icon%%',  self.inpIcon.text())
        
        f = open(dirFileName, 'w')
        f.write(dirFileText)
        f.close()

        if isNew:
        
            menuFileText = self.mainApp.readMenuTemplate()
            menuFileText = menuFileText.replace('%%name%%',  self.inpEditName.text())
            menuFileText = menuFileText.replace('%%path%%',  folderName)
            
            menuFileName = self.mainApp.folderlist.Menupath + folderName + ".menu"
            f = open(menuFileName, 'w')
            f.write(menuFileText)
            f.close()
        
        self.mainApp.showInfoPopup(self, "Your folder was successfully saved!")
    
    @pyqtSignature("")
    def on_btnAppAdd_released(self):
        """
        Slot documentation goes here.
        """
        if not self.inpAddName.text():
            self.mainApp.showInfoPopup(self, "Please select a folder first!")
            return
            
        filename = self.mainApp.foldercontent.selectApp(self)
        if not filename == "":
            self.mainApp.foldercontent.addApp(str(filename))
            self.refreshContent()
    
    @pyqtSignature("")
    def on_btnAppDelete_released(self):
        """
        Slot documentation goes here.
        """
        if not self.listApps.currentItem():
            self.mainApp.showInfoPopup(self, "Please select an application first!")
            return
            
        filename = self.listApps.currentItem().text()
        if not filename == "":
            self.mainApp.foldercontent.removeApp(str(filename))
            self.refreshContent()
    
    @pyqtSignature("")
    def on_btnUpdate_released(self):
        """
        Slot documentation goes here.
        """
        self.mainApp.foldercontent.updateFolder()
        self.mainApp.showInfoPopup(self, "Your folder was successfully saved!")
    
    @pyqtSignature("")
    def on_btnAddNameSelect_released(self):
        """
        Slot documentation goes here.
        """
        filename = self.mainApp.folderlist.selectFile()
        if not filename == "":
            self.inpAddName.setText(str(filename))
        self.mainApp.foldercontent.setFolder(str(filename))
        
        self.refreshContent()

    def refreshContent(self):
        self.listApps.clear()
        
        for app in self.mainApp.foldercontent.folderapps:
            if not self.mainApp.foldercontent.allapps[app]["icon"]  == None:
                icon = QIcon.fromTheme(self.mainApp.foldercontent.allapps[app]["icon"])
                listItem = QListWidgetItem(icon,  app,  self.listApps,  QListWidgetItem.UserType)
            else:
                listItem = QListWidgetItem(app,  self.listApps,  QListWidgetItem.UserType)
    
    @pyqtSignature("")
    def on_btnActivate_released(self):
        """
        Slot documentation goes here.
        """
        hildonMenuText = self.mainApp.readHildonMenuTemplate()
        try:
            f = open(self.hildonMenuPath, 'w')
            f.write(hildonMenuText)
            f.close()
            self.mainApp.showInfoPopup(self, "ApMeFo has been activated!")
        except:
            self.mainApp.showInfoPopup(self, "An error occured while trying to deactivate ApMeFo!")
    
    @pyqtSignature("")
    def on_btnDeactivate_released(self):
        """
        Slot documentation goes here.
        """
        try:
            os.remove(self.hildonMenuPath)
            self.mainApp.showInfoPopup(self, "ApMeFo has been deactivated!")
        except:
            self.mainApp.showInfoPopup(self, "An error occured while trying to deactivate ApMeFo!")
