/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.taskdefs.condition.Os;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread outputThread;
    private Thread errorThread;
    private StreamPumper inputPump;
    private OutputStream out;
    private OutputStream err;
    private InputStream input;
    private static final long JOIN_TIMEOUT = 500L;

    public PumpStreamHandler(OutputStream out, OutputStream err, InputStream input) {
        this.out = out;
        this.err = err;
        this.input = input;
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(out, err, null);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public void setProcessOutputStream(InputStream is) {
        this.createProcessOutputPump(is, this.out);
    }

    public void setProcessErrorStream(InputStream is) {
        if (this.err != null) {
            this.createProcessErrorPump(is, this.err);
        }
    }

    public void setProcessInputStream(OutputStream os) {
        if (this.input != null) {
            this.inputPump = this.createInputPump(this.input, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void start() {
        this.outputThread.start();
        this.errorThread.start();
        if (this.inputPump != null) {
            Thread inputThread = new Thread(this.inputPump);
            inputThread.setDaemon(true);
            inputThread.start();
        }
    }

    public void stop() {
        this.finish(this.outputThread);
        this.finish(this.errorThread);
        if (this.inputPump != null) {
            this.inputPump.stop();
        }
        try {
            this.err.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final void finish(Thread t) {
        try {
            t.join(500L);
            StreamPumper s = null;
            if (t instanceof ThreadWithPumper) {
                s = ((ThreadWithPumper)t).getPumper();
            }
            if (s != null && !s.isFinished()) {
                s.stop();
            }
            while ((s == null || !s.isFinished()) && t.isAlive()) {
                t.interrupt();
                t.join(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        return this.createPump(is, os, false);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        ThreadWithPumper result = new ThreadWithPumper(new StreamPumper(is, os, closeWhenExhausted, Os.isFamily("windows")));
        result.setDaemon(true);
        return result;
    }

    StreamPumper createInputPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        StreamPumper pumper = new StreamPumper(is, os, closeWhenExhausted, false);
        pumper.setAutoflush(true);
        return pumper;
    }

    protected static class ThreadWithPumper
    extends Thread {
        private final StreamPumper pumper;

        public ThreadWithPumper(StreamPumper p) {
            super(p);
            this.pumper = p;
        }

        protected StreamPumper getPumper() {
            return this.pumper;
        }
    }
}

