# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
import os

from PIL import Image
from PyQt4 import QtCore as QtCore
from PyQt4 import QtGui as QtGui
from filters.toolbox import *
from buttons import *


##@pyqtSignature("Bool")
def populatePhotoList(self, ForceRefresh=False):
    if self.core.thumbsCount == 0:
        self.core.thumbsCount =21
        
    self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 800, 480))
    self.core.populatePhotoList = True
    self.btnEdit.setVisible(True)
    self.btnPlistZoom.setVisible

    self.listPhotos.clear()
    
    self.repaint()
    self.tabPhoto.repaint()
    Tsize = (150, 150)
    i=0
    self.labCancel.setText("Loading Photos...")
    self.labCancel.repaint()
    if not os.path.exists (self.core.thumbsDir):
        os.makedirs (self.core.thumbsDir)

    try:
        if self.core.SearchOn:
            i =LoadDirectoryToBrowser(self, self.core.imageDir, Tsize, i,  ForceRefresh) 
        if self.core.SearchMMC:
            i =LoadDirectoryToBrowser(self, self.core.imageDirMMC, Tsize, i,  ForceRefresh)
        if i==0:
            LoadIndivPhotoToBrowser(self, self.core.DefaultCurImageDir, Tsize, i,  ForceRefresh, self.core.DefaultCurImageName) 
        
    except:
        print "Error: Loading Photos to Browser"
        reply = QtGui.QMessageBox.question(self, 'Message',"Could not find any photos. Please take a photo or change the search directory in settings.", QtGui.QMessageBox.Ok)
                
    self.listPhotos.repaint()
    self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))
    self.listPhotositemLoad(self.listPhotos.item(0))
    
def LoadDirectoryToBrowser(self, curDir, Tsize, j, ForceRefresh):
    files =[]
    try:
        for file in os.listdir(curDir):
            files.append(file)
            
        for file in reversed(files):
            if self.core.populatePhotoList ==True:
                try:

                    j= LoadIndivPhotoToBrowser(self, curDir,  Tsize, j,  ForceRefresh, file)
                except:
                    continue
            if j == self.core.thumbsCount:
                self.listPhotos.addItem("Load More...")
                break
    except:
        print "Error: Loading Photos to Browser"
        reply = QtGui.QMessageBox.question(self, 'Message',"Could not find any photos in: "+ curDir+". Please take a photo or change the search directory in settings.", QtGui.QMessageBox.Ok)
        return j
    return j
        
def LoadIndivPhotoToBrowser(self, curDir,  Tsize, k,  ForceRefresh, file):
    NULL,  NULL,  fileExtension =StripFilename(self, self.core.thumbsDir+file)
    if os.path.isdir(curDir+file) ==False:
        if ((not os.path.exists(self.core.thumbsDir+file)) or ForceRefresh):
            try:
                im = Image.open(curDir+file)
                im.thumbnail((Tsize), Image.NEAREST)
                #os.remove(self.core.thumbsDir+file)
                im.save(self.core.thumbsDir+file)
                
            except:
                return k
                

        ## Get the PListobject with predefined sizes
        photoItem = PlistWidgetItem()
        im=Image.open(self.core.thumbsDir+file,  "r" )
        
        icon =QtGui.QIcon(self.core.thumbsDir+file)
        photoItem.setIcon(icon)
        photoItem.setImageType(fileExtension)
        photoItem.setText(file.replace(photoItem.getImageType() , ""))
        photoItem.setIconSize(im.size[0], im.size[1])
        
        photoItem.setImageLocation(curDir+file)
        
        h, w = convertImSize(self.core, im.size[0], im.size[1],  300,  180)
        ##This needs to me the x.y location bplus half of the thumbnailmbnail size. so 40+(150/2)
        ##photoListZoom size is set here.
        photoItem.setIconZoomSize(ScaleLabel(self, 200,  400,  w,  h)) 

        self.listPhotos.addItem(photoItem)
        self.listPhotos.item(k).setIcon(icon)
        
        if k % 5 == 0:
            self.labCancel.setText("Loading Photos..."+str(k))
            self.labCancel.repaint()
        k+=1
        return k
    return k

def LoadCurImageFromPhotoBrowser(self):
    self.photo_Thumb.setPixmap(self.photoListZoom.pixmap())
    self.photo_Thumb.setGeometry(self.photoListZoom.geometry())
    self.photo_Thumb.setVisible(True)
    SwitchDisplayAndLoadFile(self,  self.core.plistIm)
     

class PtreeWidgetItem(QtGui.QTreeWidgetItem):
    iconSize =(0, 0)
    
class PlistWidgetItem(QtGui.QListWidgetItem):
    iconSize =(0, 0)
    iconZoomSize =(0, 0, 0, 0)
    thumbLocation= ""
    imageLocation =""
    imageType=""
    rotation =0
    
    def getRotation(self):
        GetExifRotation(imageLocation)

    def setIconSize(self,  Height=0,  Width=0):
        self.iconSize =(Height,  Width)

    def getIconSize(self):
        return self.iconSize

    def setIconZoomSize(self, value):
        self.iconZoomSize = value
        
        
    def getIconZoomSize(self):
        return self.iconZoomSize
        
    def getImageLocation(self):
        return self.imageLocation

    def setImageLocation(self, value):
        self.imageLocation = value

    def getThumbLocation(self):
        return self.thumbLocation

    def setThumbLocation(self, value):
        self.thumbLocation = value
        
    def getImageType(self):
        return self.imageType

    def setImageType(self, value):
        self.imageType = value
    
    
    class PhotoView(QtGui.QLabel):
        def __init__(self, parent=None):
            QtGui.QLabel.__init__(self, parent)
            self.setText('Lorem Ipsum')

        def mouseReleaseEvent(self, event):
            print 'Label clicked!'
