#ifndef AMETERWIDGET_H
#define AMETERWIDGET_H

#include <QtCore/QTimer>
#include <QtGui/QWidget>

#include <QtSensors/QAccelerometer>

// Neccessary for Qt Mobility API usage
QTM_USE_NAMESPACE

class AMeterWidget : public QWidget, public QAccelerometerFilter
{
    Q_OBJECT

public:
    AMeterWidget(QWidget *parent = 0);
    ~AMeterWidget();
	
	int setGravity(qreal g);

public slots:
    virtual bool filter(QAccelerometerReading *reading);

protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent(QResizeEvent *);

	void drawScale();
	
	// Background with scale
    QImage *background;

    qreal ax, ay, az;
    qreal bx, by, bz;

private:
    qreal r_g;  // 1/g
	qreal r_a_max;  // 1/a_max
};

#endif // AMETERWIDGET_H

