#ifndef AMETERWIDGET_H
#define AMETERWIDGET_H

#include <QtCore/QTimer>
#include <QtGui/QWidget>

#include <QtSensors/QAccelerometer>

/*
#include <QtSensors/QAccelerometerFilter>
#include <QtSensors/QAccelerometerReading>
*/

// Neccessary for Qt Mobility API usage
QTM_USE_NAMESPACE

#include "telepathist.h"

#define G_N 9.80665

class AMeterWidget : public QWidget, public QAccelerometerFilter
{
    Q_OBJECT

public:
    AMeterWidget(QWidget *parent = 0);
    ~AMeterWidget();

public slots:
    void tick();
	virtual bool filter(QAccelerometerReading *reading);

protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent(QResizeEvent *);

    QTimer *timer;
    QImage *image;

    qreal ax, ay, az;
	qreal bx, by, bz;
	unsigned status;
	Telepathist *telepathist;
	unsigned tt;

private:
	QAccelerometer* m_sensor;
	qreal rg;
};

#endif // AMETERWIDGET_H
