#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include "wnew.h"
#include "wrandom.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:
    void on_btnQuit_clicked();
    void on_btnNew_pressed();
    void on_btnRandom_pressed();
    void on_btnQuit_pressed();
    void on_btnNew_released();
    void on_btnRandom_released();
    void on_btnQuit_released();

    void on_btnNew_clicked();

    void on_btnRandom_clicked();

    void on_btnAbout_clicked();

private:
    Ui::MainWindow *ui;
    WRandom *wRandom;
    WNew *wNew;
};

#endif // MAINWINDOW_H
