#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "dabout.h"

#include <QtCore/QCoreApplication>


MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->setStyleSheet("MainWindow{background-color: white};");
    ui->btnNew->setStyleSheet("background: lightgreen; color: black;border-radius: 8px; border: 3px solid black;");
    ui->btnRandom->setStyleSheet("background: #fd9d9d; color: black;border-radius: 8px; border: 3px solid black;");
    ui->btnQuit->setStyleSheet("background: lightblue; color: black;border-radius: 8px; border: 3px solid black;");

    #ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    this->setWindowFlags(Qt::Window);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_btnNew_clicked()
{
    wNew=new WNew(this);
    #ifdef Q_WS_MAEMO_5
	wNew->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
	wNew->setWindowFlags(Qt::Window);
    wNew->show();

    connect(QApplication::desktop(),SIGNAL(resized(int)),wNew,SLOT(reorderUI()));
}

void MainWindow::on_btnRandom_clicked()
{
    wRandom=new WRandom(this);
    #ifdef Q_WS_MAEMO_5
	wNew->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
	wRandom->setWindowFlags(Qt::Window);
    wRandom->show();
}

void MainWindow::on_btnQuit_clicked()
{
    exit(0);
}


void MainWindow::on_btnNew_pressed()
{
    ui->btnNew->setStyleSheet("background: green; color: black;border-radius: 8px; border: 3px solid black;");
}

void MainWindow::on_btnRandom_pressed()
{
    ui->btnRandom->setStyleSheet("background: red; color: black;border-radius: 8px; border: 3px solid black;");
}

void MainWindow::on_btnQuit_pressed()
{
    ui->btnQuit->setStyleSheet("background: blue; color: black;border-radius: 8px; border: 3px solid black;");
}

void MainWindow::on_btnNew_released()
{
    ui->btnNew->setStyleSheet("background: lightgreen; color: black;border-radius: 8px; border: 3px solid black;");
}

void MainWindow::on_btnRandom_released()
{
    ui->btnRandom->setStyleSheet("background: #fd9d9d; color: black;border-radius: 8px; border: 3px solid black;");
}

void MainWindow::on_btnQuit_released()
{
    ui->btnQuit->setStyleSheet("background: lightblue; color: black;border-radius: 8px; border: 3px solid black;");
}

void MainWindow::on_btnAbout_clicked()
{
    DAbout *dAbout= new DAbout(0);
    dAbout->exec();
    delete dAbout;
}
