/* -*- mode:c; tab-width:4; c-basic-offset:4; -*-
 */
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <fcntl.h>
#include <semaphore.h>

#define AEGIS_DEBUG_ENABLED
#include <aegis_common.h>

#define MEM_NAME "/test-mem"

int 
main(int argc, char* argv[])
{
	int smem_fd = -1;
	char *mem = NULL;

	if (2 > argc) {
		fprintf(stderr, "Usage: tst_sync <show|update|wait>\n");
		return 2;
	}

	smem_fd = shm_open(MEM_NAME, O_RDWR | O_CREAT, 0644);
	if (0 > smem_fd) {
		AEGIS_ERROR("%s: failed to open/create memory (%s)", __func__, strerror(errno));
		return 1;
	}

	if (0 > flock(smem_fd, LOCK_EX)) {
		AEGIS_ERROR("%s: failed to lock memory (%s)", __func__, strerror(errno));
		return 1;
	}

	struct stat fs;
	if (0 > fstat(smem_fd, &fs)) {
		AEGIS_ERROR("%s: failed to stat memory (%s)", __func__, strerror(errno));
		return 1;
	}

	printf("mem size %lu\n", (unsigned long)fs.st_size);
	if (0 == fs.st_size) {
		if (0 > ftruncate(smem_fd, 16)) {
			AEGIS_ERROR("%s: failed to trunc memory (%s)", __func__, strerror(errno));
			return 1;
		}
	}

	mem = (char*)mmap(NULL, 16, PROT_READ | PROT_WRITE, MAP_SHARED, smem_fd, 0);

	if (MAP_FAILED == mem) {
		AEGIS_ERROR("%s: failed to mmap (%s)", __func__, strerror(errno));
		return 1;
	}

	if (0 == fs.st_size) {
		printf("init mem\n");
		memset(mem, '\0', 16);
	}

	if (0 == strcmp("show", argv[1])) {
		printf("%s\n", dynhex(mem, 16));

	} else if (0 == strcmp("update", argv[1])) {
		unsigned long *tmp = (unsigned long*)(mem + 16 - sizeof(unsigned long));
		(*tmp)++;
		usleep(5 * 1000000);

	} else if (0 == strcmp("erase", argv[1])) {
		if (0 > shm_unlink(MEM_NAME)) {
			AEGIS_ERROR("%s: failed to erase memory (%s)", __func__, strerror(errno));
			return 1;
		}
	}
	if (0 > flock(smem_fd, LOCK_UN)) {
		AEGIS_ERROR("%s: failed to unlock memory (%s)", __func__, strerror(errno));
		return 1;
	}
	if (0 > close(smem_fd)) {
		AEGIS_ERROR("%s: failed to close shm handle (%s)", __func__, strerror(errno));
		return 1;
	}
	if (0 > munmap(mem, 16)) {
		AEGIS_ERROR("%s: failed to unmap shm (%s)", __func__, strerror(errno));
		return 1;
	}
	return 0;
}
