
'''
Advanced Power Monitor Utility Library Execution
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import os, gobject, threading
gobject.threads_init()

try: import subprocess
except ImportError: import commands

def run_async(func, args=[], kwargs={}):
  t = threading.Thread(target=func, args=args, kwargs=kwargs)
  t.setDaemon(True)
  t.start()

def run_shell_command_async(cmd, banner=None):
  run_async(run_shell_command, [cmd, banner])

def run_shell_command(cmd, banner=None):
  try:
    subprocess.call(cmd, shell=True)
  except NameError:
    os.system(cmd)

def run_shell_command2(cmd, banner=None):
  try:
    subprocess.Popen(cmd, shell=True)
  except NameError:
    os.system(cmd)

def get_shell_command_output(cmd):
  result = ''
  try:
    result = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).communicate()[0]
  except NameError:
    result = commands.getoutput(cmd)
  return result
