# -*- coding: utf-8 -*-

'''
Advanced Power Common UI for configuration
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gtk, hildon

class AbstractToggleControl():

  def __init__(self, items=set()):
    self.classname = self.__class__.__name__
    self.__buttons = list()
    self.__area = self.get_area()
    self.__hbox = gtk.HBox(homogeneous=True)
    self.__area.add_with_viewport(self.__hbox)
    if items:
      self.create_group(items)

  def create_button(self, text='', group=None):
    raise NotImplementedError('%s.create_button(text=\'\', group=None) must be implemented' % self.classname)

  def add_button(self, text='', callback=None, *args):
    group = None
    if len(self.__buttons):
      group = self.__buttons[0]
    toggle_button = self.create_button(text, group)
    if callback:
      toggle_button.connect('toggled', callback, self, *args)
    self.__buttons.append(toggle_button)
    self.__hbox.pack_start(toggle_button, False, True)
    self.__area.set_size_request(-1, self.get_height())

  def get_height(self):
    return max(b.size_request()[1] for b in self.__buttons) + self.get_addon_height()

  def get_width(self):
    return sum([b.size_request()[0] for b in self.__buttons])

  def create_group(self, items=()):
    for item in items:
      try:
        try:
          self.add_button(item[0], item[1], item[2:])
        except IndexError:
          self.add_button(item[0], None)
      except IndexError:
        pass
    self.__area.set_size_request(-1, self.get_height())

  def get_box(self):
    return self.__area

  def clear(self):
    self.__hbox.destroy()
    del self.__buttons[:]
    self.__hbox = gtk.HBox(homogeneous=True)

  def remove_button(self, ind):
    try:
      button = self.__buttons.pop(ind)
      self.__hbox.remove(button)
      button.destroy()
    except IndexError:
      pass

  def set_active(self, ind):
    try:
      button = self.__buttons[ind]
      button.set_active(True)
      button.toggled()
    except IndexError:
      pass

  def get_active(self):
    b_enum = enumerate(self.__buttons)
    for n, b in b_enum:
      if b.get_active():
        return n

  def get_buttons_count(self):
    return len(self.__buttons)

  def hide(self, ind):
    self.__buttons[ind].hide_all()

  def get_addon_height(self):
    return 0

'''
Maemo 4 UI
'''
class ToggleControlMaemo4(AbstractToggleControl):

  def get_area(self):
    sa = gtk.ScrolledWindow()
    sa.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    return sa

  def create_button(self, text='', group=None):
    return gtk.RadioButton(group, text)

'''
Maemo 5 UI
'''
class ToggleControlMaemo5(AbstractToggleControl):

  def get_area(self):
    pa = hildon.PannableArea()
    pa.set_property('mov-mode', hildon.MOVEMENT_MODE_BOTH)
    pa.set_property('center-on-child-focus', True)
    return pa

  def create_button(self, text='', group=None):
     toggle_button = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, group)
     toggle_button.set_label(text)
     toggle_button.set_mode(False)
     return toggle_button

  def get_addon_height(self):
    return 0#self.get_box().style_get_property('indicator-width')
