#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import clock

def get_name():
    return "BCD Clock"

class BcdClock(clock.Clock):
    def draw_bits_vertically(self, x, y, radius, value, n):
        for i in range(n):
            self.context.arc(x + radius, y + (1.5 * radius)  + (3 * radius * i), radius, 0, 2 * math.pi)
            if (value >> (n - i - 1) & 1) > 0:
                self.context.fill_preserve()
            self.context.stroke()

    def draw_clock(self):
        h = self.time.hour
        abrv = "AM"
        if self.twelve_hour_mode :
            if h == 0 :
                h = 12
            elif h > 12 :
                h = h % 12
                abrv = "PM"

        self.draw_bits_vertically(2, 18, 3, h / 10, 2)
        self.draw_bits_vertically(12, 0, 3, h % 10, 4)
        self.draw_bits_vertically(26, 9, 3, self.time.minute / 10, 3)
        self.draw_bits_vertically(36, 0, 3, self.time.minute % 10, 4)
        if self.show_seconds:
            self.draw_bits_vertically(50, 9, 3, self.time.second / 10, 3)
            self.draw_bits_vertically(60, 0, 3, self.time.second % 10, 4)

        if self.twelve_hour_mode :
            self.context.set_font_size(int(self.text_scaling * 20))
            self.context.move_to(self.text_width, 35)
            
            self.context.text_path(abrv)
            self.context.stroke()

    def resize(self):
        if self.show_seconds :
            self.text_width = 76
        else :
            self.text_width = 47

        if self.twelve_hour_mode :
            abrv = "AM"
            if (self.font_name is not None) and self.font_name.startswith("Klingon") :
                abrv = clock.to_klingon_text(abrv)

            self.context.set_font_size(int(self.text_scaling * 20))
            self.abrv_width = self.context.text_extents(abrv)[2]
            self.abrv_width *= 1.1
        else :
            self.abrv_width = 0

        self.drawing_area.set_size_request(int(self.text_width + self.abrv_width), 36)

    def resize_alarm_enabled(self):
        if not self.twelve_hour_mode :
            clock.Clock.resize_alarm_enabled(self)

