/*
 *  Copyright 2011 Ruediger Gad
 *
 *  This file is part of Advanced Clock Plugin.
 *
 *  Advanced Clock Plugin is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Advanced Clock Plugin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Advanced Clock Plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gq/gconfitem.h>

#include <QVariant>

#include "clockdesktopconfigbutton.h"
#include "dialog.h"

ClockDesktopConfigButton::ClockDesktopConfigButton(int id, QWidget *parent) :
    QPushButton(parent)
{
    this->id = id;
    connect(this, SIGNAL(clicked()), this, SLOT(openDialog()));
}

void ClockDesktopConfigButton::copyConfigFromDefault(QString targetPath){
    QString sourcePath = Dialog::GCONF_PATH + "/clock";
    GConfItem source(sourcePath);

    QList<QString> sourceEntryNames = source.listEntries();

    for(int i = 0; i < sourceEntryNames.length(); i++){
        QString entryName = sourceEntryNames.at(i).split("/").last();

        GConfItem sItem(sourcePath + "/" + entryName);
        GConfItem tItem(targetPath + "/" + entryName);

        tItem.set(sItem.value());
    }

    GConfItem sItem(Dialog::GCONF_PATH + "/clock_name");
    GConfItem tItem(Dialog::GCONF_PATH + "/clock_name_" + QString::number(id));
    tItem.set(sItem.value());
}

void ClockDesktopConfigButton::openDialog(){
    QString path = Dialog::GCONF_PATH + "/clock_" + QString::number(id);

    GConfItem clockConfig(path);
    if(clockConfig.value() == QVariant::Invalid){
        copyConfigFromDefault(path);
    }

    Dialog dialog(id);
    dialog.setAttribute(Qt::WA_QuitOnClose, false);

    dialog.exec();
}
