#include <stdio.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <gconf/gconf-client.h>

#include "active-desktop-sp.h"

#define ACTIVE_DESKTOP_STATUS_PLUGIN_GET_PRIVATE(obj)(G_TYPE_INSTANCE_GET_PRIVATE(obj, TYPE_ACTIVE_DESKTOP_STATUS_PLUGIN, ActiveDesktopStatusPluginPrivate))

#define ICON_PATH1 "/usr/share/pixmaps/active-desktop-sp/active_desktop_1.png"
#define ICON_PATH2 "/usr/share/pixmaps/active-desktop-sp/active_desktop_2.png"
#define ICON_PATH3 "/usr/share/pixmaps/active-desktop-sp/active_desktop_3.png"
#define ICON_PATH4 "/usr/share/pixmaps/active-desktop-sp/active_desktop_4.png"
#define ICON_PATH5 "/usr/share/pixmaps/active-desktop-sp/active_desktop_5.png"
#define ICON_PATH6 "/usr/share/pixmaps/active-desktop-sp/active_desktop_6.png"
#define ICON_PATH7 "/usr/share/pixmaps/active-desktop-sp/active_desktop_7.png"
#define ICON_PATH8 "/usr/share/pixmaps/active-desktop-sp/active_desktop_8.png"
#define ICON_PATH9 "/usr/share/pixmaps/active-desktop-sp/active_desktop_9.png"

#define CURRENT_VIEW_CONF_KEY "/apps/osso/hildon-desktop/views/current"

struct _ActiveDesktopStatusPluginPrivate
{
  GdkPixbuf* icon1;
  GdkPixbuf* icon2;
  GdkPixbuf* icon3;
  GdkPixbuf* icon4;
  GdkPixbuf* icon5;
  GdkPixbuf* icon6;
  GdkPixbuf* icon7;
  GdkPixbuf* icon8;
  GdkPixbuf* icon9;
  guint gconf_notify_handler;
};

HD_DEFINE_PLUGIN_MODULE(ActiveDesktopStatusPlugin, active_desktop_status_plugin, HD_TYPE_STATUS_MENU_ITEM);

static void
_load_icons(ActiveDesktopStatusPlugin* status_plugin)
{
  status_plugin->priv->icon1 = gdk_pixbuf_new_from_file(ICON_PATH1, NULL);
  status_plugin->priv->icon2 = gdk_pixbuf_new_from_file(ICON_PATH2, NULL);
  status_plugin->priv->icon3 = gdk_pixbuf_new_from_file(ICON_PATH3, NULL);
  status_plugin->priv->icon4 = gdk_pixbuf_new_from_file(ICON_PATH4, NULL);
  status_plugin->priv->icon5 = gdk_pixbuf_new_from_file(ICON_PATH5, NULL);
  status_plugin->priv->icon6 = gdk_pixbuf_new_from_file(ICON_PATH6, NULL);
  status_plugin->priv->icon7 = gdk_pixbuf_new_from_file(ICON_PATH7, NULL);
  status_plugin->priv->icon8 = gdk_pixbuf_new_from_file(ICON_PATH8, NULL);
  status_plugin->priv->icon9 = gdk_pixbuf_new_from_file(ICON_PATH9, NULL);
}

static guint
_get_active_desktop(ActiveDesktopStatusPlugin* status_plugin)
{
  GConfClient* client = NULL;
  GError* error = NULL;
  client = gconf_client_get_default();
  if(!GCONF_IS_CLIENT(client))
  {
    return 1;
  }
  int cv = gconf_client_get_int(client, CURRENT_VIEW_CONF_KEY, &error);
  if(error)
  {
    g_error_free(error);
    cv = 1;
  }
  g_object_unref(client);
  return cv;
}

static void
_set_icon_for_active_desktop(ActiveDesktopStatusPlugin* status_plugin)
{
  guint active_desktop = _get_active_desktop(status_plugin);
  switch(active_desktop)
  {
  case 1:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon1);  
   break;
  case 2:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon2);  
   break;
  case 3:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon3);  
   break;
  case 4:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon4);  
   break;
  case 5:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon5);  
   break;
  case 6:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon6);  
   break;
  case 7:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon7);  
   break;
  case 8:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon8);  
   break;
  case 9:
   hd_status_plugin_item_set_status_area_icon(HD_STATUS_PLUGIN_ITEM(status_plugin), status_plugin->priv->icon9);  
   break;
  }
}

static void
_current_view_changed(GConfClient* client,
		      guint cnxn_id,
		      GConfEntry* entry,
		      gpointer user_data)
{
  g_return_if_fail(IS_ACTIVE_DESKTOP_STATUS_PLUGIN(user_data));
  ActiveDesktopStatusPlugin* status_plugin = ACTIVE_DESKTOP_STATUS_PLUGIN(user_data);
  _set_icon_for_active_desktop(status_plugin);
}

static void
_remove_gconf_changes(ActiveDesktopStatusPlugin* status_plugin)
{
  GConfClient* client = NULL;
  client = gconf_client_get_default();
  if(GCONF_IS_CLIENT(client))
  {
    gconf_client_notify_remove(client, 
			       status_plugin->priv->gconf_notify_handler);
    status_plugin->priv->gconf_notify_handler = 0;
    gconf_client_remove_dir(client, CURRENT_VIEW_CONF_KEY,
			    NULL);
    g_object_unref(client);
  }
}

static void
_register_gconf_changes(ActiveDesktopStatusPlugin* status_plugin)
{
  GConfClient* client = NULL;
  GError* error = NULL;
  client = gconf_client_get_default();
  if(!GCONF_IS_CLIENT(client))
  {
    return;
  }
  
  gconf_client_add_dir(client,
		       CURRENT_VIEW_CONF_KEY,
		       GCONF_CLIENT_PRELOAD_NONE,
		       &error);
  if(error != NULL)
  {
    g_warning("can not listen on gconf client changes %s\n", error->message);
    g_error_free(error);
    error = NULL;
    return;
  }
  
  status_plugin->priv->gconf_notify_handler = 
    gconf_client_notify_add(client, CURRENT_VIEW_CONF_KEY, _current_view_changed, status_plugin, NULL, &error);

  if(error != NULL)
  {
    g_warning("can not add notify on gconf client %s\n", error->message);
    g_error_free(error);
    error = NULL;
    return;
  }
  g_object_unref(client);
}

static void
active_desktop_status_plugin_init(ActiveDesktopStatusPlugin* status_plugin)
{
  status_plugin->priv = ACTIVE_DESKTOP_STATUS_PLUGIN_GET_PRIVATE(status_plugin);
  status_plugin->priv->gconf_notify_handler = 0;
  status_plugin->priv->icon1 = NULL;
  status_plugin->priv->icon2 = NULL;
  status_plugin->priv->icon3 = NULL;
  status_plugin->priv->icon4 = NULL;
  status_plugin->priv->icon5 = NULL;
  status_plugin->priv->icon6 = NULL;
  status_plugin->priv->icon7 = NULL;
  status_plugin->priv->icon8 = NULL;
  status_plugin->priv->icon9 = NULL;

  _load_icons(status_plugin);
  _set_icon_for_active_desktop(status_plugin);
  _register_gconf_changes(status_plugin);
}

static void
active_desktop_status_plugin_finalize(GObject* object)
{
  ActiveDesktopStatusPlugin* status_plugin = ACTIVE_DESKTOP_STATUS_PLUGIN(object);
  if(status_plugin->priv->gconf_notify_handler != 0)
  {
    _remove_gconf_changes(status_plugin);
  }
  if(status_plugin->priv->icon1 != NULL)
    g_object_unref(status_plugin->priv->icon1);
  if(status_plugin->priv->icon2 != NULL)
    g_object_unref(status_plugin->priv->icon2);
  if(status_plugin->priv->icon3 != NULL)
    g_object_unref(status_plugin->priv->icon3);
  if(status_plugin->priv->icon4 != NULL)
    g_object_unref(status_plugin->priv->icon4);
  if(status_plugin->priv->icon5 != NULL)
    g_object_unref(status_plugin->priv->icon5);
  if(status_plugin->priv->icon6 != NULL)
    g_object_unref(status_plugin->priv->icon6);
  if(status_plugin->priv->icon7 != NULL)
    g_object_unref(status_plugin->priv->icon7);
  if(status_plugin->priv->icon8 != NULL)
    g_object_unref(status_plugin->priv->icon8);
  if(status_plugin->priv->icon9 != NULL)
    g_object_unref(status_plugin->priv->icon8);
  G_OBJECT_CLASS(active_desktop_status_plugin_parent_class)->finalize (object);
}

static void
active_desktop_status_plugin_class_finalize(ActiveDesktopStatusPluginClass* klass)
{
}

static void
active_desktop_status_plugin_class_init(ActiveDesktopStatusPluginClass* klass)
{
  g_type_class_add_private(klass, sizeof(ActiveDesktopStatusPluginPrivate));
  G_OBJECT_CLASS(klass)->finalize = (GObjectFinalizeFunc)active_desktop_status_plugin_finalize;
}

